# (c) 1999 - AccesSoft - See license.txt for details
# $Id: staticobj.py,v 1.1 2004/02/12 20:20:18 daveron Exp $
#----------------------------------------------------------------------
# this provides object permanence by storing the object in an ODBC RDBMS
#----------------------------------------------------------------------

import cPickle
import ODBC.MySQL

class StaticObject:
	def __init__(self, cursor, id=None):

		try: id = int(id)
		except: id = None

		if not id: # assign a new id
			cursor.execute ('update obj_seq set id=last_insert_id(id+1)')
			cursor.execute ('select last_insert_id()')
			(id,) = cursor.fetchone()

		self.__dict__['__i_id__'] = id
		self.__dict__['__i_cursor__'] = cursor


	def __getattr__(self,name):
		c = self.__dict__['__i_cursor__']

		try:
			c.execute ("select value from obj where id = ? and name = ?", \
				(self.__dict__['__i_id__'], name))
			(value,) = c.fetchone()
		except:
			return None

		value = cPickle.loads(value)
		self.__dict__[name] = value
		return value


	def __setattr__(self,name,value):
		if name[:4] == '__i_': return

		c = self.__dict__['__i_cursor__']

		try: pklval = cPickle.dumps(value, 1)
		except: return
		
		if pklval == None: return

		try: strval = str(value)
		except: strval = None

		if self.__dict__.has_key(name):
			try:
				success = c.execute ('update obj ' \
					+ 'set value = ?, strvalue = ? ' \
					+ 'where id = ? and name = ?', \
					(pklval, strval, self.__dict__['__i_id__'], name))
			except: success = 0
		else: success = 0

		if not success:
			try:
				c.execute ('insert into obj (id, name, value, strvalue) ' \
					+ 'values (?, ?, ?, ?)', \
					(self.__dict__['__i_id__'], name, pklval, strval))
			except: return

		self.__dict__[name] = value


	def __delattr__(self,name):
		if name[:4] == '__i_': return

		c = self.__dict__['__i_cursor__']

		c.execute ('delete from obj where id = ? and name = ?', \
			(self.__dict__['__i_id__'], name))

		del self.__dict__[name]


	def __str__(self):
		return str (self.__dict__['__i_id__'])


	def __int__(self):
		return int (self.__dict__['__i_id__'])
