# (c) 1999 - AccesSoft - See license.txt for details
# $Id: moophelp.py,v 1.1 2004/02/12 20:20:18 daveron Exp $
#----------------------------------------------------------------------
# MOOP help module
#----------------------------------------------------------------------

import os
import pickle
import string
os.chdir('../var')
helpDB={}

class HelpRec:
    def __init__(self, syntax='', desc='', initial=0):
        self.syntax = syntax        # one-line syntax summary
        self.desc = desc            # long description
        self.initial = initial        # if 1, appears in initial "topics" list

    def __repr__(self):
        return "HelpRec(syntax=%s, desc=%s, initial=%s)" % (`self.syntax`,
                                                           `self.desc`,
                                                           self.initial) 
    def show(self):
        if self.syntax:
            return "Syntax: " + self.syntax + "\n" + self.desc + "\n\n"
        else:
            return self.desc + "\n\n"

    def enter(self):
        self.syntax = raw_input("Enter syntax string: ")
        print "Enter help message, period(.) alone to end:"
        print "------------------------------------------"
        done=0
        self.desc=""
        while not done:
            tex = raw_input()
            if tex==".": done = 1
            else: self.desc = self.desc+"\n"+tex
        ans = raw_input("Show on initial topics list? ")
        self.initial = (ans[0]=='y' or ans[0]=='Y' or ans[0]=='1')

def hSave(filename='moophelp.dat'):
    global helpDB
    file = open(filename, 'w')
    pickle.dump(helpDB, file)
    file.close()

def hLoad(filename='moophelp.dat'):
    global helpDB
    try:
        file = open(filename, 'r')
        helpDB = pickle.load(file)
        file.close()
    except IOError:
        new() 
        hSave()

def hPrint(filename=''):
    import sys
    if filename:
        file = open(filename, 'w')
        oldstdout = sys.stdout
        sys.stdout = file
    for key, val in helpDB.items():
        print key
        print `val`
    if filename:
        sys.stdout = oldstdout

def hImport(filename='moophelp.txt'):
    global helpDB
    try:
        file = open('../text/'+filename, 'r')
    except IOError:
        print "Unable to open filename: %s" % filename
        return
    while 1:
        topic = file.readline()[:-1]
        if not topic:
            break
        value = file.readline()
        if not value:
            raise IOError("Unexpected EOF")
        exec "hr = %s" % value
        helpDB[topic] = hr
        
def new():
    global helpDB
    return "Creating empty help database..."
    helpDB = {}

def help(topic=None):
    global helpDB
    if not topic:
        output = "Available help topics:\n\n"
        lst = filter(lambda x:helpDB[x].initial, helpDB.keys())
        lst.sort()
        for topic in lst:
            output = output + "   "+ topic + "\n"
        return output + "\n"
    else:
        try:
            return helpDB[topic].show()
        except:
            # if no exact match is found, what about a partial match?
            lst = filter(lambda x,a=topic,l=len(topic): x[:l]==a,helpDB.keys())
            if not (lst): 
                if (topic[:3] == "at_"):
                    return help( "@" + topic[3:] )
                return "No help available on "+topic+".\n"
            if len(lst) > 1:
                return "Ambiguous topic:\n   " + string.join(lst,'\n   ')+'\n'
            return helpDB[lst[0]].show()

def addTopic(topic):
    global helpDB
    hr = HelpRec()
    hr.enter()
    helpDB[topic] = hr

def deleteTopic(topic):
    global helpDB
    try: del helpDB[topic]
    except: print "Couldn't delete topic",topic

def popDB():
    done = 0
    helpStr=  """Enter one of:
              .quit   .save   .load [<filename>] .new .print [<filename>]
              .help [<topic>]   .del <topic>  .import [<filename>] .?  
           (Commands may be abbreviated to the first letter.)"""
    print helpStr
    while not done:
        foo = raw_input("help>")
        arg = ''
        if string.find(foo, ' ') > -1:
            foo, arg = string.split(foo, ' ', 2)
        cmd = foo[:2]
        if cmd == ".q": done = 1
        elif cmd == ".s": hSave()
        elif cmd == ".l":
            if arg:
                hLoad(arg)
            else:
                hLoad()
        elif cmd == ".n": new()
        elif cmd == ".p":
            if arg:
                hPrint(arg)
            else:
                hPrint()
        elif cmd == ".i":
            if arg:
                hImport(arg)
            else:
                hImport()
        elif cmd == ".h" or cmd == ".d":
            if cmd == ".h": print help(arg)
            elif cmd==".d": deleteTopic(arg)
        elif cmd == ".?":
            print helpStr
        elif cmd == ".": pass
        elif cmd == "": pass
        else: addTopic(foo)

if __name__ == '__main__':
    popDB()

#-------------------------
# End-of-file
#-------------------------

