# Setup for Testing utilities, source in for sh/ksh/bash/zsh....
#       source this into your shell to get these aliases:
#
# alias  action
# -----  ------------------------------------------------------------
# t      compile amd test
# t1     compile and test using valgrind or ktrace with j_lib2
# t2     compile and test using valgrind or ktrace without j_lib2
# et     execute gvim for view all files created by a test run
# sman   view a manual (.man)
# b      Generate a Makefile
# m      execute make(1)
# c      execute 'make clean'
# m1     perform a full build/make
#
#==========================================================================
# Copyright (c) 2022 ... 2025 2026
#     John McCue <jmccue@sdf.org>
#
# Permission to use, copy, modify, and distribute this software
# for any purpose with or without fee is hereby granted, provided
# that the above copyright notice and this permission notice
# appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
# WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
# LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#==========================================================================

OS="`uname -s`"
HOST="`hostname -s`"
export OS HOST

#
# f_sman() -- format a manual
#
f_sman()
{
    l_file_man=""
    l_prog_nroff="nroff -man"
    l_prog_cat=cat

    if test "$1" = ""
    then
	if test "`ls *.man | wc -l | sed 's/ //g'`" -eq "1"
	then
	    l_file_man="`ls *.man`"
	fi
    else
	l_file_man="$1"
    fi

    if test -f "$l_file_man"
    then
	if test "$TERM" != "dumb"
	then
	    type less > /dev/null 2>&1
	    if test "$?" -eq "0"
	    then
		l_prog_cat=less
	    else
		l_prog_cat=more
	    fi
	fi
    else
	echo "sman: manual file $l_file_man not supplied, leaving"
	return
    fi

    type mandoc > /dev/null 2>&1
    if test "$?" -eq "0"
    then
	l_prog_nroff="mandoc"
	$l_prog_nroff -T lint $l_file_man
	if test "$?" -ne "0"
	then
	    unset l_file_man
	    unset l_prog_nroff
	    unset l_prog_cat
	    return
	fi
    fi
    
    $l_prog_nroff $l_file_man | $l_prog_cat

    unset l_prog_nroff
    unset l_file_man
    unset l_prog_cat

} # END: f_sman()

#
# f_ihdr() -- install just j_lib2 headers, sometimes needed
#             for compiling changes to j_lib2
#
f_ihdr()
{
    l_i1_local="$1"
    type doas > /dev/null 2>&1
    if test "$?" -eq "0"
    then
	l_i1_doas="doas"
    else
	l_i1_doas="sudo"
    fi

    if test ! -d "$l_i1_local"
    then
	echo "f_ihdr: missing dir $l_i1_local"
	l_i1_local=""
	l_i1_doas=""
	return
    fi

    diff $HOME/src/util/j_lib2/j_lib2m.h $l_i1_local/j_lib2m.h > /dev/null 2>&1
    if test "$?" -eq "0"
    then
	echo "f_ihdr: no need to update j_lib2m.h"
    else
	$l_i1_doas cp -v $HOME/src/util/j_lib2/j_lib2m.h /opt/jmc/include/j_lib2m.h
    fi

    diff $HOME/src/util/j_lib2/j_lib2.h $l_i1_local/j_lib2.h > /dev/null 2>&1
    if test "$?" -eq "0"
    then
	echo "f_ihdr: no need to update j_lib2.h"
    else
	$l_i1_doas cp -v $HOME/src/util/j_lib2/j_lib2.h /opt/jmc/include/j_lib2.h
    fi

    l_i1_local=""
    l_i1_doas=""

} # END: f_ihdr()

f_t1()
{
    l_t1_arg="$1"

    $TEST_DIR_SRC/t-$TEST_DIR_NAME.sh YES_J YES_MEM $l_t1_arg > $RAMDISK/log_test.txt 2>&1
    if test "$OS" = "OpenBSD"
    then
	gvim $RAMDISK/log_test.txt $DIRRESULTS/*
    fi

    unset l_t1_arg

} # END: f_t1

f_t2()
{
    l_t2_arg="$1"

    $TEST_DIR_SRC/t-$TEST_DIR_NAME.sh NO_J YES_MEM $l_t2_arg > $RAMDISK/log_test.txt 2>&1
    if test "$OS" = "OpenBSD"
    then
	gvim $RAMDISK/log_test.txt $DIRRESULTS/*
    fi

    unset l_t2_arg

} # END: f_t2

#--- find / setup test results directory
#    RAMDISK can be a tmpfs or mfs (OpenBSD)
if test "$RAMDISK" = ""
then
    if test -d "/mnt/mfs"
    then
	RAMDISK="/mnt/mfs/$USER"
    else
	if test -d "/mnt/tmpfs"
	then
	    RAMDISK="/mnt/tmpfs/$USER"
	else
	    RAMDISK="/tmp/$USER"
	fi
    fi
    export RAMDISK
    if test ! -d "$RAMDISK"
    then
	mkdir "$RAMDISK" && chmod 700 "$RAMDISK"
    fi
    if test ! -d "$RAMDISK/$HOST"
    then
	mkdir "$RAMDISK/$HOST" && chmod 700 "$RAMDISK/$HOST"
    fi
fi

#--- install j_lib2 headers
if test -f "/opt/jmc/include/j_lib2m.h"
then
    alias i1="f_ihdr /opt/jmc/include"
else
    if test -f "/usr/local/include/j_lib2m.h"
    then
	alias i1="f_ihdr /usr/local/include"
    fi
fi

if test -f "build.sh"
then
    S=`pwd`
    alias b="./build.sh"
else
    if test -f config_make.sh
    then
        S=`pwd`
        alias b="./config_make.sh"
    else
	if test -f Makefile
	then
	    S=`pwd`
	fi
    fi
    if test -f gen_make.sh
    then
        S=`pwd`
        alias b="./gen_make.sh"
    fi
fi
if test ! -d "$S"
then
    S="$HOME/src/util/Template"
fi
export S

#--- set default install location
if test -d "/opt/jmc"
then
    PREFIX="/opt/jmc"
else
    if test "$SDF" = "YES"
    then
	PREFIX="$HOME/local"
    else
	PREFIX="/usr/local"
    fi
fi
REAL_DIR="$PREFIX"
DESTDIR="$PREFIX"
export PREFIX REAL_DIR DESTDIR

#--- send gemini docs to the server
if test -d $HOME/Docs/WEB/gemini
then
    G="$HOME/Docs/WEB/gemini"
    export G
    alias gput="$G/bin/put.sh"
fi

#----- continue
alias sman="f_sman"
alias m="make -f Makefile ; rm TAGS"
alias c="make -f Makefile clean"

if test "$TERM" = "dumb"
then
    if test -x gen_make.sh
    then
	alias m1="make clean -f Makefile ; ./gen_make.sh && make -f Makefile"
    else
	alias m1="make clean -f Makefile ; ./build.sh && make -f Makefile"
    fi
else
    if test -x gen_make.sh
    then
	alias m1="make clean -f Makefile ; ./gen_make.sh && make -f Makefile ; rm TAGS > /dev/null 2>&1"
    else
	alias m1="make clean -f Makefile ; ./build.sh && make -f Makefile ; rm TAGS > /dev/null 2>&1"
    fi
fi

#--- test related settings
TEST_DIR_NAME="`basename $S`"
TEST_DIR_PARENT="`dirname $S`"
TEST_DIR_SRC="$TEST_DIR_PARENT/$TEST_DIR_NAME"
DIRRESULTS="$RAMDISK/$HOST/$TEST_DIR_NAME"
RESULTS="$DIRRESULTS/make_results.txt"
T="$DIRRESULTS"
export TEST_DIR_NAME TEST_DIR_PARENT TEST_DIR_SRC DIRRESULTS RESULTS T

alias et="gvim $RAMDISK/$HOST/$TEST_DIR_NAME/*"
alias e1="gvim $HOME/src/util/TODO"
alias t="$TEST_DIR_SRC/t-$TEST_DIR_NAME.sh"
alias t1="f_t1"
alias t2="f_t2"

#--- show settings
cat << EOF
==========================================================================
PREFIX           $PREFIX
DESTDIR          $DESTDIR

TEST_DIR_PARENT  $TEST_DIR_PARENT
TEST_DIR_NAME    $TEST_DIR_NAME
TEST_DIR_SRC     $TEST_DIR_SRC	(also set to \$S)
DIRRESULTS       $DIRRESULTS	(also set to \$T)
==========================================================================
EOF

### END
