# Setup for Testing utilities, source in for csh/tcsh
#       source this into your shell to get these aliases:
#
# alias  action
# -----  ------------------------------------------------------------
# t      compile and test
# t1     compile and test using valgrind or ktrace with j_lib2
# t2     compile and test using valgrind or ktrace without j_lib2
# et     execute gvim for view all files created by a test run
# sman   view a manual (.man)
# b      Generate a Makefile
# m      execute make(1)
# c      execute 'make clean'
# m1     perform a full build/make
#
#==========================================================================
# Copyright (c) 2022 ... 2025 2026
#     John McCue <jmccue@sdf.org>
#
# Permission to use, copy, modify, and distribute this software
# for any purpose with or without fee is hereby granted, provided
# that the above copyright notice and this permission notice
# appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
# WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
# LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#==========================================================================

setenv OS	`uname -s`
setenv HOST	`hostname -s`

#--- find / setup test results directory
#    RAMDISK can be a tmpfs or mfs (OpenBSD)
if ( ! $?RAMDISK ) then
    if ( -d /mnt/mfs ) then
	setenv RAMDISK	/mnt/mfs/$USER
    else
	if ( -d /mnt/tmpfs ) then
	    setenv RAMDISK	/mnt/tmpfs/$USER
	else
	    setenv RAMDISK	/tmp/$USER
	endif
    endif
    if ( ! -d $RAMDISK ) then
	mkdir $RAMDISK && chmod 700 $RAMDISK
    endif
    if ( ! -d $RAMDISK/$HOST ) then
	mkdir $RAMDISK/$HOST && chmod 700 $RAMDISK/$HOST
    endif
endif

#--- if using emacs shell
if ( "$TERM" =~ "dumb") then
    if ( $?tcsh ) then
	if ( -f ~/.tcshrc ) then
	    source ~/.tcshrc && source ~/.login
	    echo emacs ready for tcsh
	endif
    else
        if ( -f ~/.cshrc ) then
	    source ~/.cshrc && source ~/.login
	    echo emacs ready for csh
	endif
    endif
    if ( $OS =~ "Linux" ) then
	alias ls "/usr/bin/ls -b -T 0"
	alias lg "/usr/bin/ls -CF -b -T 0"
	alias lc "/usr/bin/ls -CF -b -T 0"
    endif
endif

unalias b m m1 c i1 i2 t t1 t2

#--- install j_lib2 headers
if ( -f /opt/jmc/include/j_lib2m.h ) then
    alias i1 "diff ~/src/util/j_lib2/j_lib2m.h /opt/jmc/include/j_lib2m.h || sudo cp -v ~/src/util/j_lib2/j_lib2m.h /opt/jmc/include/j_lib2m.h ; echo ''"
    alias i2 "diff ~/src/util/j_lib2/j_lib2.h  /opt/jmc/include/j_lib2.h  || sudo cp -v ~/src/util/j_lib2/j_lib2.h  /opt/jmc/include/j_lib2.h  ; echo ''"
else
    if ( -f /usr/local/include/j_lib2m.h ) then
	alias i1 "diff ~/src/util/j_lib2/j_lib2m.h /usr/local/include/j_lib2m.h || sudo cp -v ~/src/util/j_lib2/j_lib2m.h /usr/local/include/j_lib2m.h ; echo ''"
	alias i2 "diff ~/src/util/j_lib2/j_lib2.h  /usr/local/include/j_lib2.h  || sudo cp -v ~/src/util/j_lib2/j_lib2.h  /usr/local/include/j_lib2.h  ; echo ''"
    endif
endif

if ( -f build.sh ) then
    setenv S `pwd`
    alias b "./build.sh"
else
    if ( -f config_make.sh ) then
        setenv S `pwd`
        alias b "./config_make.sh"
    else
	if ( -f Makefile ) then
	    setenv S `pwd`
	endif
    endif
    if ( -f gen_make.sh ) then
        setenv S `pwd`
        alias b "./gen_make.sh"
    endif
endif
if ( ! $?S ) then
    setenv S	~/src/util/Template
endif

#--- set default install location
if ( -d "/opt/jmc" ) then
    setenv PREFIX	/opt/jmc
    setenv REAL_DIR	$PREFIX
    setenv DESTDIR	$PREFIX
else
    if ( $?SDF ) then
	if ( "$SDF" == "YES" ) then
	    setenv PREFIX	~/local
	else
	    setenv PREFIX	/usr/local
	endif
    else
	setenv PREFIX	/usr/local
    endif
    setenv REAL_DIR	$PREFIX
    setenv DESTDIR	$PREFIX
endif

#--- send gemini docs to the server
if ( -d ~/Docs/WEB/gemini ) then
    setenv G	~/Docs/WEB/gemini
    alias gput	$G/bin/put.sh
endif

#----- continue
alias m make -f Makefile
alias c make -f Makefile clean

which mandoc >& /dev/null
if ( $status == 0 ) then
    alias sman mandoc \!:1
else
    alias sman nroff -man \!:1
endif

#--- alias for rebuild all
if ( "$TERM" == "dumb" ) then
    if ( -x gen_make.sh ) then
	alias m1	"make clean -f Makefile ; ./gen_make.sh && make -f Makefile"
    else
	alias m1	"make clean -f Makefile ; ./build.sh && make -f Makefile"
    endif
else
    if ( -x gen_make.sh ) then
	alias m1	"make clean -f Makefile ; ./gen_make.sh && make -f Makefile ; rm TAGS >& /dev/null"
    else
	alias m1	"make clean -f Makefile ; ./build.sh && make -f Makefile ; rm TAGS >& /dev/null"
    endif
endif

#--- test related aliases
setenv TEST_DIR_NAME	"`basename $S`"
setenv TEST_DIR_PARENT	"`dirname $S`"
setenv TEST_DIR_SRC	$TEST_DIR_PARENT/$TEST_DIR_NAME
setenv DIRRESULTS	$RAMDISK/$HOST/$TEST_DIR_NAME
setenv RESULTS		$DIRRESULTS/make_results.txt
setenv T		$DIRRESULTS

alias et	"gvim $RAMDISK/$HOST/$TEST_DIR_NAME/*"
alias e1	gvim ~/src/util/TODO
alias t		$TEST_DIR_SRC/t-$TEST_DIR_NAME.sh

if ( $OS =~ "OpenBSD" ) then
    alias t1	"$TEST_DIR_SRC/t-$TEST_DIR_NAME.sh YES_J YES_MEM \!:1 >& $RAMDISK/log_test.txt ; gvim $RAMDISK/log_test.txt $DIRRESULTS/*"
    alias t2	"$TEST_DIR_SRC/t-$TEST_DIR_NAME.sh NO_J YES_MEM \!:1 >& $RAMDISK/log_test.txt ; gvim $RAMDISK/log_test.txt $DIRRESULTS/*"
else
    alias t1	$TEST_DIR_SRC/t-$TEST_DIR_NAME.sh YES_J YES_MEM
    alias t2	$TEST_DIR_SRC/t-$TEST_DIR_NAME.sh NO_J YES_MEM
endif

#--- show settings
cat << EOF
==========================================================================
PREFIX           $PREFIX
DESTDIR          $DESTDIR

TEST_DIR_PARENT  $TEST_DIR_PARENT
TEST_DIR_NAME    $TEST_DIR_NAME
TEST_DIR_SRC     $TEST_DIR_SRC	(also set to \$S)
DIRRESULTS       $DIRRESULTS	(also set to \$T)
==========================================================================
EOF

### END
