## Test Scripts for Utilities

Repositories:
* [gitlab repository](https://gitlab.com/jmcunx1/test) (this site)
* gemini://gem.sdf.org/jmccue/computer/repoinfo/test.gmi (mirror)
* gemini://sdf.org/jmccue/computer/repoinfo/test.gmi (mirror)

These files are used in conjunction with
each test script in the utility repository.
Optionally the test script can use
valgrind(1) or kdump(1) to look for memory leaks.
See arguments below.

| OS | Memory Check Method |
| :--- | :--- |
| Linux | valgrind(1), if installed |
| OpenBSD | ktrace(1) and kdump(1) |
| Others | Memory Testing not performed |

**File description:**
| File | How used |
| :--- | :--- |
| tsetup.sh | source script used by all Test Scrpts, t-XXXXX.sh, for each utility |
| setup.csh | csh and tcsh source script to define aliases to help with testing |
| setup.sh | sh type shell source script to define aliases to help with testing |

One important note, use of
[j\_lib2](https://gitlab.com/jmcunx1/j_lib2)
is automatically determined.
[j\_lib2](https://gitlab.com/jmcunx1/j_lib2) is **not** required
for these utilities.

**Arguments for Testing**

Arguments can be supplied to determine how to test.
These arguments are optional, default action is noted.

| Argument | Action |
| :--- | :--- |
| NO\_MEM | Do not perform Memory Testing (default). |
| YES\_MEM | Perform Memory Testing. |
| NO\_J | Compile without using [j\_lib2](https://gitlab.com/jmcunx1/j_lib2). |
| YES\_J | Compile with using [j\_lib2](https://gitlab.com/jmcunx1/j_lib2). |
| SKIP | Do not automatically compile prior to executing the test.  By default, the object is compiled. |
| others | A couple of test scripts have their own specific arguments, use --help to see the arguments. |

**To Test:**
* These should be stored in dir "test"
* Execute t-XXXXX.sh where XXXXX is the program to be tested.
For example,
[t-jfile.sh](https://gitlab.com/jmcunx1/jfile/-/blob/main/t-jfile.sh?ref_type=heads)
will test utility [jfile](https://gitlab.com/jmcunx1/jfile).

Licensed using the
[ISC Licence](https://en.wikipedia.org/wiki/ISC_license).
