#!/bin/sh
#
# rtave test with valgrind or ktrace
#
# Copyright (c) 2022 ... 2025 2026
#     John McCue <jmccue@sdf.org>
#
# Permission to use, copy, modify, and distribute this software
# for any purpose with or without fee is hereby granted, provided
# that the above copyright notice and this permission notice
# appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
# WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
# LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

g_dir_bhome=`dirname $0`
cd $g_dir_bhome
g_dir_bhome=`pwd`
. $g_dir_bhome/../test/tsetup.sh

#
# main
#

g_file_src=$TEST_DIR_SRC/test_data/job_list.txt
g_file_out=$DIR_RESULTS/file_out.csv
g_file_err=$DIR_RESULTS/val_err.txt
g_file_input_a=$DIR_RESULTS/val_in_a.txt
g_file_input_b=$DIR_RESULTS/val_in_b.txt
g_file_input_c=$DIR_RESULTS/val_in_c.txt

cd $TEST_DIR_SRC
f_ckprog ./rtave
f_ckfile r "$g_file_src"

#--- generate data files
if test ! -f "$g_file_input_a"
then
    f_msg "I011: creating Input Files"
    grep '_A$' < "$g_file_src" | sed 's/|//g' > "$g_file_input_a"
    grep '_B$' < "$g_file_src" | sed 's/|//g' > "$g_file_input_b"
    grep '_C$' < "$g_file_src" | sed 's/|//g' > "$g_file_input_c"
fi

#--- print version info
./rtave -V > "$FILE_VERSION_RESULTS" 2>&1
cat << EOF >> $FILE_MAKE_RESULTS 2>&1
=====================================================================
Source  Dir: $TEST_DIR_SRC
Results Dir: $DIR_RESULTS

Program Rev:
---------------------------------------------------------------------
`cat $FILE_VERSION_RESULTS`
=====================================================================
EOF
rm $FILE_VERSION_RESULTS $FILE_VALGRIND_LOG > /dev/null 2>&1

#--- Test object
if test "$PROCESS_VALGRIND" = "Y"
then
    f_msg "A200: START ./rtave $MSG_MEMORY" >> "$FILE_VALGRIND_LOG"
    f_msg "I201: START ./rtave $MSG_MEMORY"
    valgrind -s --tool=memcheck --leak-check=yes               \
                --leak-check=full --show-leak-kinds=all        \
                --track-origins=yes                            \
                --keep-stacktraces=alloc-then-free             \
	        ./rtave -Hc -vvv -f -o "$g_file_out" -e "$g_file_err"         \
                        "$g_file_input_a" "$g_file_input_b" "$g_file_input_c" \
                >> "$FILE_VALGRIND_LOG" 2>&1
    f_msg "I210: Created: $FILE_VALGRIND_LOG" >> "$FILE_VALGRIND_LOG"
    f_msg "I211:        : $g_file_out" >> "$FILE_VALGRIND_LOG"
    f_msg "I212:        : $g_file_err" >> "$FILE_VALGRIND_LOG"
    if test "$TERM" = "dumb"
    then
	cat $FILE_VALGRIND_LOG
    fi
    f_msg "I290: END   ./rtave $MSG_MEMORY"
    f_msg "B291: END   ./rtave $MSG_MEMORY"     >> "$FILE_VALGRIND_LOG"
else
    f_msg "I300: START ./rtave $MSG_MEMORY"
    $OPENBSD_KTRACE ./rtave -Hc -vvv -f -o "$g_file_out" -e "$g_file_err" \
                            "$g_file_input_a" "$g_file_input_b"         \
                            "$g_file_input_c"
    f_msg "I310: Created: $g_file_out"
    f_msg "I312:        : $g_file_err"
    if test "$OPENBSD_KTRACE" != ""
    then
	sleep 1
	kdump -u malloc
	sleep 1
	f_msg "I313: ***** Execute this:"
	f_msg "I314:       addr2line -e ./rtave 0x????"
	f_msg "I315: ***** using the last hex val on the line for ./rtave"
	f_msg "I316: ***** to see where the leak is (if any)"
    fi
    f_msg "I320: END   ./rtave $MSG_MEMORY"
fi

exit 0
