.\"
.\" Copyright (c) 2003 ... 2025 2026
.\"     John McCue <jmccue@sdf.org>
.\"
.\" Permission to use, copy, modify, and distribute this software
.\" for any purpose with or without fee is hereby granted,
.\" provided that the above copyright notice and this permission
.\" notice appear in all copies.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
.\" WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
.\" THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
.\" CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
.\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\" SOFTWARE.
.\"
.TH JWC 1 "2003-12-06" "JMC" "User Commands"
.SH NAME
jwc - display text file stats
.SH SYNOPSIS
jwc [OPTIONS] [FILE...]
.SH DESCRIPTION
Print byte, word, newline counts for each FILE, and
a total line if more than one FILE is specified.
When no files are specified, stdin is used.
.SH OPTIONS
.TP
-a
Optional, All checks on.  Show all file statistics, print headings
.TP
-b
Optional, Show number of bytes (characters)
.TP
-E
Optional, When calculating Min/Max Line Size, use this option
to expand TABs to spaces.
.TP
-e file
Optional, Errors written to the file specified, defaults to stderr.
.TP
-f
Optional, Force file create.
Create file even if the target file exists.
.TP
-H
Optional, Print column headings
.TP
-h
Optional, Show brief help and exit
.TP
-L
Optional, print length of the longest line
.TP
-l
Optional, print newline counts, this can be viewed as the number of
records in the text file.
.TP
-N
Optional, print line number of the shortest line
.TP
-o file
Optional, Write output to the file specified, defaults to stdout.
.TP
-q
Optional, do not print file open errors
.TP
-s
Optional, print length of the shortest line
.TP
-V
Optional, output version information and exit
.TP
-v
Optional, Verbose Level.
Print information about the run,
default do not show run messages.
Can be specified multiple times,
each specification increases verbose level:
.nf
    Level  Meaning
    -----  -------------------------------------
    = 0    Do not show any messages, default
    >= 1   Show summary and warnings on stderr
    >= 2   Show arguments on stderr
.TP
-w
Optional, print word counts
.TP
-X
Optional, print line number of the longest line

.SH DIAGNOSTICS
By default, TABs are not expanded into spaces, but counted as
one character. This differs from UNIX wc(1), but this behaviour
can be changed by using argument '-E'.
.PP
Processes one line at a time, assumes the file is a text file.
.PP
Lines, words and mix/max line size may not be calculated correctly
for binary files, number of bytes will be correct.
.PP
Byte and character counts are the same, arguments only for
compatibility.
.PP
If no arguments specified, it is as if this
command is executed:
.nf
    jwc -l -w -b
.fi

.SH BUGS
Do not know of any.

.SH ENVIRONMENT
none.

.SH AUTHOR
John McCue

.SH ERROR-CODES
.nf
0 success
1 processing error
.fi

.SH SEE-ALSO
wc(1)
