#!/bin/sh
#
# justleft - test with valgrind and ktrace
#
# Copyright (c) 2022 ... 2025 2026
#     John McCue <jmccue@sdf.org>
#
# Permission to use, copy, modify, and distribute this software
# for any purpose with or without fee is hereby granted, provided
# that the above copyright notice and this permission notice
# appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
# WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
# LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

g_dir_bhome=`dirname $0`
cd $g_dir_bhome
g_dir_bhome=`pwd`
. $g_dir_bhome/../test/tsetup.sh

g_file_err=$DIR_RESULTS/val_err.txt
g_file_out=$DIR_RESULTS/val_out.txt
g_file_check_sed=$DIR_RESULTS/val_check.txt
g_file_check_just=$DIR_RESULTS/val_check_justlefttxt
g_verbose="-vvv"

cd $TEST_DIR_SRC
f_ckprog ./justleft
f_ckprog expand
f_ckprog sed

#--- print version info
./justleft -V > "$FILE_VERSION_RESULTS" 2>&1
cat << EOF >> $FILE_MAKE_RESULTS 2>&1
=====================================================================
Source  Dir: $TEST_DIR_SRC
Results Dir: $DIR_RESULTS

Program Rev:
---------------------------------------------------------------------
`cat $FILE_VERSION_RESULTS`
=====================================================================
EOF
rm $FILE_VERSION_RESULTS $FILE_VALGRIND_LOG    > /dev/null 2>&1
rm "$g_file_err" "$g_file_out" "$g_file_check_sed" > /dev/null 2>&1

#--- Test object
if test "$PROCESS_VALGRIND" = "Y"
then
    f_msg "A200: START ./justleft $MSG_MEMORY" > "$FILE_VALGRIND_LOG"
    f_msg "I201: START ./justleft $MSG_MEMORY"
    valgrind -s --tool=memcheck --leak-check=yes        \
                --leak-check=full --show-leak-kinds=all \
                --track-origins=yes                     \
                --keep-stacktraces=alloc-then-free      \
	        ./justleft $g_verbose -f -e $g_file_err -o $g_file_out *.c *.h \
                >> "$FILE_VALGRIND_LOG" 2>&1
    if test "$TERM" = "dumb"
    then
	cat $FILE_VALGRIND_LOG
    fi
    f_msg "I281: Created: $FILE_VALGRIND_LOG"
    f_msg "I282:          $g_file_out"
    f_msg "I282:          $g_file_err"
    f_msg "I290: END   ./justleft $MSG_MEMORY"
    f_msg "B291: END   ./justleft $MSG_MEMORY"     >> "$FILE_VALGRIND_LOG"
else
    f_msg "I300: START ./justleft $MSG_MEMORY"
    $OPENBSD_KTRACE ./justleft $g_verbose -f -e $g_file_err -o $g_file_out *.c *.h
    f_msg "I303: Created: $g_file_out"
    f_msg "I304:          $g_file_err"
    if test "$OPENBSD_KTRACE" != ""
    then
	sleep 1
	kdump -u malloc
	sleep 1
	f_msg "I313: ***** Execute this:"
	f_msg "I314:       addr2line -e ./justleft 0x????"
	f_msg "I315: ***** using the last hex val on the line for ./justleft"
	f_msg "I316: ***** to see where the leak is (if any)"
    fi
    f_msg "I390: END   ./justleft $MSG_MEMORY"
fi

#--- Validation
f_msg "I500: Validating Results"
expand *.c *.h | sed 's/^ *//g' > "$g_file_check_sed"
expand *.c *.h | ./justleft     > "$g_file_check_just"

diff "$g_file_check_sed" "$g_file_check_just" > /dev/null 2>&1
if test "$?" -eq "0"
then
    f_msg "I501: SUCCESS ./justleft vs sed(1)"
    rm "$g_file_check_sed" "$g_file_check_just"
else
    f_msg "W502: FAILED  ./justleft vs sed(1)"
    f_msg "W503: See Files:"
    f_msg "W504    $g_file_check_sed"
    f_msg "E505    $g_file_check_just"
fi

exit 0
