/*
 * Copyright (c) 1999 ... 2025 2026
 *     John McCue <jmccue@sdf.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef JUSTLEFT_H

#define JUSTLEFT_H "3.12 2025/08/12"
#define PROG_NAME  "justleft"

#define USG_MSG_JUSTLEFT_1 "Remove leading white space (Left Justify) each line in a Text File"

#ifndef JLIB2_CHAR_NULL
#define NO_JLIB 1
#define JLIB2_INT_NULL   ((int) '\0')
#define JLIB2_CHAR_NULL  ((char) '\0')
#define JLIB2_UCHAR_NULL ((unsigned char) '\0' )
#endif

#ifndef NULL
#define NULL '\0'
#endif
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#ifndef SSIZE_T
#define SSIZE_T ssize_t
#endif
#ifndef TAB_CHAR
#define TAB_CHAR 0x09
#endif

#ifdef MAXPATHLEN
#ifndef PATH_MAX
#define PATH_MAX MAXPATHLEN
#endif
#else
#ifdef PATH_MAX
#define MAXPATHLEN PATH_MAX
#endif
#endif

#define PATH_IS_VALID   0
#define PATH_IS_NULL    1
#define PATH_IS_EMPTY   2
#define PATH_IS_BIG     3
#define PATH_HAS_SPACE  4
#define PATH_INVALID    5

struct s_file_info
{
  FILE *fp;
  char fname[(PATH_MAX + 1)];
  int ok_to_close;
} ;

struct s_counts
{
  long int read;
  long int writes;
  long int bytes_read;
  long int bytes_writes;
} ;

struct s_work
{
  struct s_file_info err;
  struct s_file_info out;
  int verbose;
  int num_files;
  int force;          /* verbose level */
  int rtw;            /* TRUE or FALSE */
} ;

/*** messages ***/
#ifdef NO_JLIB
#define ARG_ERR           'e'  /* Output Error File                  */
#define ARG_FORCE         'f'  /* force create files                 */
#define ARG_HELP          'h'  /* Show Help                          */
#define ARG_OUT           'o'  /* Output File                        */
#define ARG_RTW           'R'  /* remove trailing spaces             */
#define ARG_VERBOSE       'v'  /* Verbose                            */
#define ARG_VERSION       'V'  /* Show Version Information           */
#define FILE_NAME_STD     "-"
#define SWITCH_CHAR       '-'

#define LIT_C80           "::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::"
#define LIT_INFO_04       "Build: %s %s\n"
#define LIT_NO            "No"
#define LIT_NULL          "<null>"
#define LIT_REV           "Revision"
#define LIT_STDERR        "(standard error)"
#define LIT_STDIN         "(standard input)"
#define LIT_STDOUT        "(standard output)"
#define LIT_TALLF         "Total all Files"
#define LIT_YES           "Yes"

#define MSG_ERR_E000      "Try '%s %c%c' for more information\n"
#define MSG_ERR_E002      "ERROR E002: Cannot open '%s' for write, processing aborted\n"
#define MSG_ERR_E004S     "ERROR E004: value '%s' invalid value for %c%c\n"
#define MSG_ERR_E004SB    "ERROR E004: value '%s' value for %c%c too large\n"
#define MSG_ERR_E025      "ERROR E025: File %s cannot be created, already exists\n"
#define MSG_ERR_E074      "ERROR E074: 'Too many Arguments specified for %c%c\n"
#define MSG_ERR_E080      "ERROR E080: cannot allocate initial memory : %s\n"
#define MSG_ERR_E112      "ERROR E112: cannot open %s, already opened\n"
#define MSG_ERR_E113      "ERROR E113: stdin can only be used once\n"

#define MSG_INFO_I023     "I023:            Lines Read:  %9ld\n"
#define MSG_INFO_I024     "I024:            Bytes Read:                      %9ld\n"
#define MSG_INFO_I035     "I035:         Lines Written:  %9ld\n"
#define MSG_INFO_I041     "I041:         Bytes Written:                      %9ld\n"
#define MSG_INFO_I043L    "I043: Input  File                  : %s\n"
#define MSG_INFO_I081     "I081: Number of Input Files          %d\n"
#define MSG_INFO_I086     "I086: Errors written to File       : %s\n"
#define MSG_INFO_I087     "I087: Force Create Output          ? %s\n"
#define MSG_INFO_I090     "I090: Output written to File       : %s\n"
#define MSG_INFO_I092     "I092: Verbose Level                  %d\n"
#define MSG_INFO_I152S    "I152: Run Time: %lld second(s)\n"
#define MSG_INFO_I186     "I186: Remove trailing white space  ? %s\n"

#define MSG_WARN_W002     "W002: Open Error Bypass File '%s' : %s\n"

#define USG_MSG_ARG_ERR        "\t%c%c file\t\t: Write errors to file 'file', default stderr\n"
#define USG_MSG_ARG_FORCE      "\t%c%c\t\t: force create of files when found\n"
#define USG_MSG_ARG_HELP       "\t%c%c\t\t: Show brief help and exit\n"
#define USG_MSG_ARG_OUT        "\t%c%c file\t\t: Write output to file 'file', default stdout\n"
#define USG_MSG_ARG_RTW        "\t%c%c\t\t: Remove Trailing White space\n"
#define USG_MSG_ARG_VERBOSE_5  "\t%c%c\t\t: show run stats on stderr\n"
#define USG_MSG_ARG_VERSION    "\t%c%c\t\t: Show revision information and exit\n"
#define USG_MSG_OPTIONS        "Options\n"
#define USG_MSG_USAGE          "usage:\t%s [OPTIONS] [FILES ...]\n"
#endif /* NO_JLIB */

/*** prototypes ***/
int  open_in(struct s_file_info *, struct s_file_info *, char *);
void open_out(struct s_file_info *, char *, int);
void close_file(struct s_file_info *);
char *get_progname(char *, char *);
void init_finfo(struct s_file_info *);
void init_counts(struct s_counts *);
void show_rev();
void show_help();
void check_path_file(FILE *, char *, char);

#ifdef NO_JLIB
SSIZE_T j2_getline(char **buf, size_t *n, FILE *fp);
int j2_f_exist(char *file_name);
long int j2_bye_last(char *x, char lastc);
long int j2_clr_str(char *s, char c, int size);
long int j2_justleft(char *s);
long int j2_rtw(char *buffer);
#define j2_bye_nl(x)    j2_bye_last((x), '\n')
#define j2_bye_ctlm(x)  j2_bye_last((x), '\r')
#endif /* NO_JLIB */

#endif /* JUSTLEFT_H */

/* END: justleft.h */
