/*
 * Copyright (c) 1999 ... 2025 2026
 *     John McCue <jmccue@sdf.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#define _FILE_OFFSET_BITS 64
#define __USE_LARGEFILE64
#define _TIME_BITS 64

#ifndef _MSDOS
#include <sys/param.h>
#endif
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#ifdef HAVE_JLIB
#include <j_lib2.h>
#include <j_lib2m.h>
#endif

#include "justleft.h"

/*
 * show_rev() -- displays Version Information
 */
void show_rev()

{

  fprintf(stderr,"%s: %s\n", PROG_NAME, USG_MSG_JUSTLEFT_1);

#ifdef J_LIB2_H
  fprintf(stderr, "\t%s\n", j2_get_build());
#endif

  fprintf(stderr, "\t%s %s: %s - ", LIT_REV, PROG_NAME, JUSTLEFT_H);
  fprintf(stderr, LIT_INFO_04, __DATE__, __TIME__);

#ifdef OSTYPE
  fprintf(stderr,"\t%s\n", OSTYPE);
#endif
#ifdef PRETTY_NAME
  fprintf(stderr,"\t%s\n",PRETTY_NAME);
#endif  /* PRETTY_NAME  */

  exit(EXIT_FAILURE);

} /* show_rev() */

/*
 * show_help() -- displays show_help info and exits
 */
void show_help()

{

  fprintf(stderr, USG_MSG_USAGE, PROG_NAME);
  fprintf(stderr, "\t%s\n", USG_MSG_JUSTLEFT_1);
  fprintf(stderr, USG_MSG_OPTIONS);
  fprintf(stderr, USG_MSG_ARG_ERR,       SWITCH_CHAR, ARG_ERR);
  fprintf(stderr, USG_MSG_ARG_FORCE,     SWITCH_CHAR, ARG_FORCE);
  fprintf(stderr, USG_MSG_ARG_HELP,      SWITCH_CHAR, ARG_HELP);
  fprintf(stderr, USG_MSG_ARG_OUT,       SWITCH_CHAR, ARG_OUT);
  fprintf(stderr, USG_MSG_ARG_RTW,       SWITCH_CHAR, ARG_RTW);
  fprintf(stderr, USG_MSG_ARG_VERBOSE_5, SWITCH_CHAR, ARG_VERBOSE);
  fprintf(stderr, USG_MSG_ARG_VERSION,   SWITCH_CHAR, ARG_VERSION);

  exit(EXIT_FAILURE);

} /* show_help() */

/* just_h.c */
