#!/bin/sh
#
# juniq - test with valgrind or ktrace
#
# Copyright (c) 2022 ... 2025 2026
#     John McCue <jmccue@sdf.org>
#
# Permission to use, copy, modify, and distribute this software
# for any purpose with or without fee is hereby granted, provided
# that the above copyright notice and this permission notice
# appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
# WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
# LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

g_dir_bhome=`dirname $0`
cd $g_dir_bhome
g_dir_bhome=`pwd`
. $g_dir_bhome/../test/tsetup.sh

g_file_in="$DIR_RESULTS/val_in.txt"
g_file_out="$DIR_RESULTS/val_out.txt"
g_file_err="$DIR_RESULTS/val_err.txt"
g_file_uniq="$DIR_RESULTS/val_uniq.txt"
g_arg_count="-c"

cd $TEST_DIR_SRC
f_ckprog awk
f_ckprog sort
f_ckprog ./juniq

#--- Create Input File
if test ! -f "$g_file_in"
then
    f_msg "I200: START Creating Input File"
    tr -cd '[:digit:]' < /dev/urandom | fold -w 3 | sed 10000q \
         | awk '{printf("%03d\n", $1)}' | sort > "$g_file_in"
    f_msg "I201: END   Creating Input File"
fi

#--- print version info
./juniq -V > "$FILE_VERSION_RESULTS" 2>&1
cat << EOF >> $FILE_MAKE_RESULTS 2>&1
=====================================================================
Source  Dir: $TEST_DIR_SRC
Results Dir: $DIR_RESULTS

Program Rev:
---------------------------------------------------------------------
`cat $FILE_VERSION_RESULTS`
=====================================================================
EOF
rm $FILE_VERSION_RESULTS $FILE_VALGRIND_LOG   > /dev/null 2>&1
rm "$g_file_out" "$g_file_err" "$g_file_uniq" > /dev/null 2>&1

#--- Test object
if test "$PROCESS_VALGRIND" = "Y"
then
    f_msg "A301: START   ./juniq $MSG_MEMORY" > "$FILE_VALGRIND_LOG"
    f_msg "I302: START   ./juniq $MSG_MEMORY"
    valgrind -s --tool=memcheck --leak-check=yes                   \
                --leak-check=full --show-leak-kinds=all            \
                --track-origins=yes                                \
                --keep-stacktraces=alloc-then-free                 \
	        ./juniq $g_arg_count -f -vv -o $g_file_out -e $g_file_err "$g_file_in" \
                >> "$FILE_VALGRIND_LOG" 2>&1
    f_msg "I310: Created: $FILE_VALGRIND_LOG" >> "$FILE_VALGRIND_LOG"
    f_msg "I311:        : $g_file_out" >> "$FILE_VALGRIND_LOG"
    f_msg "I312:        : $g_file_err" >> "$FILE_VALGRIND_LOG"
    if test "$TERM" = "dumb"
    then
	cat $FILE_VALGRIND_LOG
    fi
    f_msg "I391: END     ./juniq $MSG_MEMORY"
    f_msg "B390: END     ./juniq $MSG_MEMORY"     >> "$FILE_VALGRIND_LOG"
else
    f_msg "I401: START   ./juniq $MSG_MEMORY"
    $OPENBSD_KTRACE ./juniq $g_arg_count -f -vv -o $g_file_out \
                            -e $g_file_err "$g_file_in" 
    f_msg "I410: Created: $g_file_out"
    f_msg "I412:        : $g_file_err"
    if test "$OPENBSD_KTRACE" != ""
    then
	sleep 1
	kdump -u malloc
	sleep 1
	f_msg "I413: ***** Execute this:"
	f_msg "I414:       addr2line -e ./juniq 0x????"
	f_msg "I415: ***** using the last hex val on the line for ./juniq"
	f_msg "I416: ***** to see where the leak is (if any)"
    fi
    f_msg "I420: END     ./juniq $MSG_MEMORY"
fi

#--- validate
f_msg "I500: Validating Results"
uniq $g_arg_count "$g_file_in" > "$g_file_uniq"
diff -w "$g_file_out" "$g_file_uniq" > /dev/null 2>&1
if test "$?" -eq "0"
then
    rm "$g_file_uniq"
    f_msg "I501: SUCCESS ./juniq vs uniq(1)"
else
    f_msg "W502: FAILED  ./juniq vs uniq(1)"
    f_msg "W503: See Files:"
    f_msg "W504    $g_file_uniq"
    f_msg "E505    $g_file_out"
fi

exit 0
