/*
 * Copyright (c) 2012 ... 2025 2026
 *     John McCue <jmccue@sdf.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#define _FILE_OFFSET_BITS 64
#define __USE_LARGEFILE64
#define _TIME_BITS 64

#ifndef _MSDOS
#include <sys/param.h>
#endif

#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <fcntl.h>
#include <time.h>

#ifdef HAVE_JLIB
#include <j_lib2.h>
#include <j_lib2m.h>
#endif

#include "jsplit.h"

/*
 * init_w() -- initialize work area
 */
void init_w(struct s_work *w)

{
  init_finfo(&(w->err));
  w->err.fp    = stderr;

  w->min_allowed      = (jm_counter) 1;
  w->max_allowed      = JS_MAX_BYTES;
  w->max_items        = JS_MAX_BYTES;
  w->limit            = JS_MAX_SPLIT; /* max number of output files */
  w->num_files        = 0;
  w->verbose          = 0;
  w->force            = (int) FALSE;
  w->split_binary     = (int) TRUE;
  w->random_split     = (int) FALSE;

}  /* init_w() */

/*
 * init() -- initialize
 */
void init(int argc, char **argv, struct s_work *w)

{

  init_w(w);

  process_arg(argc, argv, w);

  if (w->random_split == TRUE)
    w->max_items = j2_randrange(w->min_allowed, w->max_allowed);

  if (w->verbose > 1)
    {
      fprintf(w->err.fp, MSG_INFO_I086,
              (strlen(w->err.fname) == 0 ? LIT_STDERR : w->err.fname));
      fprintf(w->err.fp, MSG_INFO_I092, w->verbose);
      fprintf(w->err.fp, MSG_INFO_I087, (w->force == TRUE ? LIT_YES : LIT_NO));
      if (w->split_binary == TRUE)
	  fprintf(w->err.fp, MSG_INFO_I176);
      else
	  fprintf(w->err.fp, MSG_INFO_I177);
      if (w->random_split == TRUE)
	{
	  fprintf(w->err.fp, MSG_INFO_I170);
	  fprintf(w->err.fp, MSG_INFO_I171, (long long int) w->min_allowed);
	  fprintf(w->err.fp, MSG_INFO_I172, (long long int) w->max_allowed);
	}
      else
	{
	  fprintf(w->err.fp, MSG_INFO_I173);
	  fprintf(w->err.fp, MSG_INFO_I174, (long long int) w->max_items);
	}
      fprintf(w->err.fp, MSG_INFO_I175, (long long int) w->limit);
    }

}  /* init() */
