/*
 * Copyright (c) 2012 ... 2025 2026
 *     John McCue <jmccue@sdf.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#define _FILE_OFFSET_BITS 64
#define __USE_LARGEFILE64
#define _TIME_BITS 64

#ifndef _MSDOS
#include <sys/param.h>
#endif

#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#ifdef HAVE_JLIB
#include <j_lib2.h>
#include <j_lib2m.h>
#endif

#include "jsplit.h"

#define MSG_HELP_11  "Split Large Files"

/*
 * show_brief_help()
 */
void show_brief_help()

{

  fprintf(stderr, USG_MSG_USAGE_5, PROG_NAME);
  fprintf(stderr, "\t%s\n", MSG_HELP_11);
  fprintf(stderr, USG_MSG_OPTIONS);
  fprintf(stderr, USG_MSG_ARG_ERR,          SWITCH_CHAR, ARG_ERR);
  fprintf(stderr, USG_MSG_ARG_FORCE,        SWITCH_CHAR, ARG_FORCE);
  fprintf(stderr, USG_MSG_ARG_HELP,         SWITCH_CHAR, ARG_HELP);
  fprintf(stderr, USG_MSG_ARG_MIN_2,        SWITCH_CHAR, ARG_MIN_SIZE);
  fprintf(stderr, USG_MSG_ARG_LIMIT_FILES,  SWITCH_CHAR, ARG_LIMIT_FILES);
  fprintf(stderr, USG_MSG_ARG_MAX_2,        SWITCH_CHAR, ARG_MAX_SIZE);
  fprintf(stderr, USG_MSG_ARG_RANDOM_SPLIT, SWITCH_CHAR, ARG_RANDOM_SPLIT);
  fprintf(stderr, USG_MSG_ARG_TEXT_1,       SWITCH_CHAR, ARG_TEXT);
  fprintf(stderr, USG_MSG_ARG_VERSION,      SWITCH_CHAR, ARG_VERSION);
  fprintf(stderr, USG_MSG_ARG_VERBOSE_5,    SWITCH_CHAR, ARG_VERBOSE);

  exit(EXIT_FAILURE);

}  /* show_brief_help() */

/*
 * show_rev()
 */
void show_rev()

{

  fprintf(stderr,"%s %s:\n", PROG_NAME, MSG_HELP_11);

#ifdef J_LIB2_H
  fprintf(stderr, "\t%s\n", j2_get_build());
#endif

  fprintf(stderr, "\t%s %s: %s - ", LIT_REV, PROG_NAME, JSPLIT_H);
  fprintf(stderr, LIT_INFO_04, __DATE__, __TIME__);

#ifdef OSTYPE
  fprintf(stderr,"\t%s\n",OSTYPE);
#endif  /* OSTYPE  */
#ifdef PRETTY_NAME
  fprintf(stderr,"\t%s\n",PRETTY_NAME);
#endif  /* PRETTY_NAME  */

  exit(EXIT_FAILURE);

}  /* show_rev() */
