.\"
.\" Copyright (c) 2012 ... 2025 2026
.\"     John McCue <jmccue@sdf.org>
.\"
.\" Permission to use, copy, modify, and distribute this software
.\" for any purpose with or without fee is hereby granted,
.\" provided that the above copyright notice and this permission
.\" notice appear in all copies.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
.\" WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
.\" THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
.\" CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
.\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\" SOFTWARE.
.\"
.TH JSPLIT 1 "2012-12-08" "JMC" "Local Command"
.SH NAME
jsplit - Execute to splits binary or text files into small files
.SH SYNOPSIS
jsplit [OPTIONS] [FILE]
.SH DESCRIPTION
Splits the input file into many smaller files.
Files created will be named 'v#######.x' where '#######'
is a number between 0 and 9999999.
.PP
If no file (FILE) is specified on the command line or
if FILE has name '-', stdin (Standard Input) is used.
.TP
-e file
Optional, if used, write error messages and status messages to file 'file'.
If not specified, messages will be written to stderr.
.TP
-f
Optional, force file create when the target file exists.
Default is to abort.
.TP
-h
Show brief help and exit.
.TP
-L min
Optional, minimum number of bytes or lines to use when splitting
the input file, must be greater than 0.
Default is 1, BUT ignored unless Argument '-r' is supplied.
.TP
-l num
Optional, limit the number of output files created.
Instead of potentially creating 9999999 files,
set the maximum number of files created to 'num'.
Once this limit is reached, all remaining data will be
written to the last output file.
.TP
-M max
Optional, number of bytes or lines to use when splitting
the input file, must be greater than 0.
Default is 1000 bytes or lines per
output.
This value can be randomised using Argument '-r'.
.TP
-r
Optional, instead if using a fixed Maximum Value (-M)
for the Split Value, used a random Maximum Value.
.TP
-t
Optional, process as a Text File,
split will be performed on new-line boundaries.
The default is to process as a binary file.
.TP
Optional, Verbose Level.
Print information about the run,
default do not show run messages.
Can be specified multiple times,
each specification increases verbose level:
.nf
    Level  Meaning
    -----  -------------------------------------
    = 0    Do not show any messages, default
    >= 1   Show stats and warnings on stderr
    >= 2   Show arguments on stderr
.TP
-V
output version information and exit.
.SH DIAGNOSTICS
If available you should use split(1), it is much faster.
.PP
If you decide to Randomise the Maximum File size '-r',
Arguments '-L' and '-M' are used to determine the Random
Value Range.
.PP
Note, if an error occurs while parsing command line arguments,
errors may be written stderr instead of the error file specified.
.PP
Only one input file can be specified,
if more than one input file is specified program will abort.
.PP
If the number of output files reaches maximum allowed,
all remaining data will be written to the last file.
.PP
In some Operating Systems, program may fail after
creating many 'split' files in the current directory.
If this happens try argument '-l' to limit the number of
files created.
.PP
Force argument '-f' is ignored for output split files,
ie: named 'v######.x'.
This prevents mixing of split data from different files
or runs.
.SH SEE-ALSO
dd(1),
j(1),
jcomb(1),
split(1)
.SH ERROR-CODES
.nf
0         success
non-zero  process error or help/rev displayed
.fi
