#!/bin/sh
#
# jside - test with valgrind or ktrace
#
# Copyright (c) 2022 ... 2025 2026
#     John McCue <jmccue@sdf.org>
#
# Permission to use, copy, modify, and distribute this software
# for any purpose with or without fee is hereby granted, provided
# that the above copyright notice and this permission notice
# appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
# WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
# LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

g_dir_bhome=`dirname $0`
cd $g_dir_bhome
g_dir_bhome=`pwd`
. $g_dir_bhome/../test/tsetup.sh

f_create_file()
{
    l_count=0
    l_max=100

    echo "REC_COUNT,COL-B,COL-C,COL-D,COL-E,COL-F"

    while test $l_count -lt $l_max
    do
	l_count=`expr "$l_count" + 1`
	echo "$l_count" \
	    | awk '{printf("%d,COL-2.%d,COL-3.%d,COL-4.%d,COL-5.%d,COL-6.%d\n",$1,$1,$1,$1,$1,$1)}';
    done

} # END: f_create_file()

#
# main
#
g_file_in=$DIR_RESULTS/val_in.csv
g_file_err=$DIR_RESULTS/val_err.txt
g_file_out=$DIR_RESULTS/val_out.csv

if test ! -f "$g_file_in"
then
    f_msg "I010: Creating Input"
    f_create_file > "$g_file_in"
fi

cd $TEST_DIR_SRC
f_ckprog ./jside
f_ckfile "r" "$g_file_in"

#--- print version info
./jside -V > "$FILE_VERSION_RESULTS" 2>&1
cat << EOF >> $FILE_MAKE_RESULTS 2>&1
=====================================================================
Source  Dir: $TEST_DIR_SRC
Results Dir: $DIR_RESULTS

Program Rev:
---------------------------------------------------------------------
`cat $FILE_VERSION_RESULTS`
=====================================================================
EOF
rm $FILE_VERSION_RESULTS $FILE_VALGRIND_LOG > /dev/null 2>&1

#--- Test object
if test "$PROCESS_VALGRIND" = "Y"
then
    f_msg "A200: START valgrind ./jside $MSG_MEMORY" > "$FILE_VALGRIND_LOG"
    f_msg "I201: START valgrind ./jside $MSG_MEMORY"
    valgrind -s --tool=memcheck --leak-check=yes                 \
                --leak-check=full --show-leak-kinds=all          \
                --track-origins=yes                              \
                --keep-stacktraces=alloc-then-free               \
	        ./jside -vvv -f -e $g_file_err -o $g_file_out "$g_file_in" \
                >> "$FILE_VALGRIND_LOG" 2>&1
    if test "$TERM" = "dumb"
    then
	cat $FILE_VALGRIND_LOG
    fi
    f_msg "I281: Created: $FILE_VALGRIND_LOG"
    f_msg "I282:          $g_file_out"
    f_msg "I282:          $g_file_err"
    f_msg "I291: END   ./jside $MSG_MEMORY"
    f_msg "B292: END   ./jside $MSG_MEMORY"     >> "$FILE_VALGRIND_LOG"
else
    f_msg "I300: START ./jside $MSG_MEMORY"
    $OPENBSD_KTRACE ./jside -vvv -f -e $g_file_err -o $g_file_out "$g_file_in"
    f_msg "I301: Created: $g_file_out"
    f_msg "I302:          $g_file_err"
    if test "$OPENBSD_KTRACE" != ""
    then
	sleep 1
	kdump -u malloc
	sleep 1
	f_msg "I313: ***** Execute this:"
	f_msg "I314:       addr2line -e ./jside 0x????"
	f_msg "I315: ***** using the last hex val on the line for ./jside"
	f_msg "I316: ***** to see where the leak is (if any)"
    fi
    f_msg "I320: END   ./jside $MSG_MEMORY"
fi

exit 0
