.\"
.\" Copyright (c) 2019 ... 2025 2026
.\"     John McCue <jmccue@sdf.org>
.\"
.\" Permission to use, copy, modify, and distribute this software
.\" for any purpose with or without fee is hereby granted,
.\" provided that the above copyright notice and this permission
.\" notice appear in all copies.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
.\" WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
.\" THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
.\" CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
.\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\" SOFTWARE.
.\"
.TH JSIDE 1 "2019-06-18" "JMC" "User Commands"
.SH NAME
jside - print delimited file side ways.
.SH SYNOPSIS
jside [OPTIONS] [FILE...]
.SH DESCRIPTION
Prints columns if a Delimited File sideways, generating
a csv file to allow easy comparison.
.PP
If no files (FILE) are specified on the command line or
if FILE has name '-', stdin (Standard Input) is used.
.TP
-D delm
Optional, Output Field Delimiter.
Default is a comma ','.
.TP
-d delm
Optional, Input Field Delimiter.
Default is a comma ','.
-e file
Optional, if used, write error messages to file 'file'.
If not specified, errors written to stderr.
.TP
-f
Optional, Force file create.
Create file even if the target file exists.
.TP
-h
Show brief help and exit.
.TP
-m max
Optional, maximum number of columns to process.
If not specified will process only the first 200 columns.
.TP
-o file
Optional, if used, write output to file 'file'.
If not specified, output written to stdout.
.TP
-V
Output version information and exit.
.TP
-v
Optional, Verbose Level.
Print information about the run,
default do not show run messages.
Can be specified multiple times,
each specification increases verbose level:
.nf
    Level  Meaning
    -----  -------------------------------------
    = 0    Do not show any info, default
    >= 1   Show run stats on stderr
    >= 2   Show arguments on stderr
    >= 3   Print Source File Name on stdout
.fi
.SH DIAGNOSTICS
Beware, if you are processing a file with a
large number of records, your spreadsheet program
may not be able to read all of the data on Output.
.PP
Double Quotes are are treated as any other character.
This means 'real' csv files when processed will
retain the double quotes.
This also means all Data is considered Character Data.
.SH SEE-ALSO
awk(1),
cut(1),
jcsv(local),
jr(local),
paste(1),
sed(1)
.SH ERROR-CODES
.nf
0 success
1 processing error or help/rev displayed
.fi
