#!/bin/sh
#
# jr - test and can optionally test using valgrind or ktrace
#
# Copyright (c) 2022 ... 2025 2026
#     John McCue <jmccue@sdf.org>
#
# Permission to use, copy, modify, and distribute this software
# for any purpose with or without fee is hereby granted, provided
# that the above copyright notice and this permission notice
# appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
# WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
# LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

g_dir_bhome=`dirname $0`
cd $g_dir_bhome
g_dir_bhome=`pwd`
. $g_dir_bhome/../test/tsetup.sh

#
# f_test_01()
#
f_test_01()
{
    l_t01_ifile=$g_dir_in/t01_ifile.txt
    l_t01_ofile=$DIR_RESULTS/val-t01.out
    l_t01_rfile=$DIR_RESULTS/val-t01.rpt
    l_t01_efile=$DIR_RESULTS/val-t01.err
    l_t01_vfile=$DIR_RESULTS/valgrind_t01.err
    l_t01_ecode="0"

    f_msg "IT01_01: Creating $l_t01_ofile"

    rm "$l_t01_vfile" > /dev/null 2>&1

    if test "$PROCESS_VALGRIND" = "Y"
    then
	f_msg "IT01_02: START ./jr, Test 1 $MSG_MEMORY"
	valgrind -s --tool=memcheck --leak-check=yes        \
		    --leak-check=full --show-leak-kinds=all \
		    --track-origins=yes                     \
		    --keep-stacktraces=alloc-then-free      \
			./jr -d 124 -vf               \
	                     -r "$l_t01_rfile"        \
	                     -e "$l_t01_efile"        \
			     -C c,6,10,,z,CUST        \
			     -C n,3,11,12,zf,Count    \
			     -C c,1,20,21,te,Name     \
			     -C c,4,15,16,U,Code      \
			     -o "$l_t01_ofile"        \
	                     "$l_t01_ifile"  >> "$l_t01_vfile" 2>&1
	l_t01_ecode="$?"
    else
	f_msg "IT01_03: START ./jr, Test 1 $MSG_MEMORY"
	$OPENBSD_KTRACE ./jr -d 124 -vf -r "$l_t01_rfile" -e "$l_t01_efile" \
	     -C c,6,10,,z,CUST        \
	     -C n,3,11,12,zf,Count    \
	     -C c,1,20,21,te,Name     \
	     -C c,4,15,16,U,Code      \
	     -o "$l_t01_ofile" "$l_t01_ifile"
	l_t01_ecode="$?"
    fi

    if test "$l_t01_ecode" -ne "0"
    then
	cat "$l_t01_efile"
	f_msg "ET01_10: failed Test 1, $l_t01_ifile"
    fi

    f_msg "IT01_20: Created $l_t01_ofile"
    f_msg "IT01_21:         $l_t01_efile"
    if test -f "$l_t01_vfile"
    then
	f_msg "IT01_23:         $l_t01_vfile"
    fi
    if test "$OPENBSD_KTRACE" != ""
    then
	sleep 1
	kdump -u malloc
	sleep 1
	f_msg "It01_30: ***** Execute this:"
	f_msg "It01_31:       addr2line -e ./jr 0x????"
	f_msg "It01_32: ***** using the last hex val on the line for ./jr"
	f_msg "It01_33: ***** to see where the leak is (if any)"
    fi
    f_msg "IT01_40: END   ./jr, Test 1 $MSG_MEMORY"

} # END: f_test_01()

#
# f_test_02()
#
f_test_02()
{
    l_t02_ifile=$g_dir_in/t02_ifile.txt
    l_t02_ofile=$DIR_RESULTS/val-t02.out
    l_t02_rfile=$DIR_RESULTS/val-t02.rpt
    l_t02_efile=$DIR_RESULTS/val-t02.err
    l_t02_vfile=$DIR_RESULTS/valgrind_t02.err
    l_t02_ecode="0"

    l_t02_max_uppr=120
    l_t02_max_name=120
    l_t02_max_coun=20
    l_t02_max_addi=33000
    l_t02_max_addr=255
    l_t02_max_city=60
    l_t02_max_stat=20
    l_t02_max_zipc=75
    l_t02_pos_name=""
    l_t02_pos_coun=""
    l_t02_pos_addi=""
    l_t02_pos_addr=""
    l_t02_pos_city=""
    l_t02_pos_stat=""
    l_t02_pos_zipc=""
    l_t02_pos_uppr=1

    l_t02_pos_name=`expr "$l_t02_max_uppr" + "$l_t02_pos_uppr"`
    l_t02_pos_coun=`expr "$l_t02_max_name" + "$l_t02_pos_name"`
    l_t02_pos_addi=`expr "$l_t02_max_coun" + "$l_t02_pos_coun"`
    l_t02_pos_addr=`expr "$l_t02_max_addi" + "$l_t02_pos_addi"`
    l_t02_pos_city=`expr "$l_t02_max_addr" + "$l_t02_pos_addr"`
    l_t02_pos_stat=`expr "$l_t02_max_city" + "$l_t02_pos_city"`
    l_t02_pos_zipc=`expr "$l_t02_max_stat" + "$l_t02_pos_stat"`

    f_msg "IT02_01: Creating $l_t02_ofile"

    rm "$l_t02_vfile" > /dev/null 2>&1
    if test "$PROCESS_VALGRIND" = "Y"
    then
	f_msg "IT02_02: START ./jr, Test 2 $MSG_MEMORY"
	valgrind -s --tool=memcheck --leak-check=yes        \
		    --leak-check=full --show-leak-kinds=all \
		    --track-origins=yes                     \
		    --keep-stacktraces=alloc-then-free      \
			./jr -d 124 -vf -r "$l_t02_rfile" -e "$l_t02_efile"  \
			    -C c,1,$l_t02_max_uppr,$l_t02_max_uppr,t,NAME_UPP   \
			    -C c,2,$l_t02_max_name,$l_t02_max_name,t,NAME       \
			    -C c,3,$l_t02_max_coun,$l_t02_max_coun,t,COUNTRY    \
			    -C c,4,$l_t02_max_addi,$l_t02_max_addi,t,ADD_INFO   \
			    -C c,5,$l_t02_max_addr,$l_t02_max_addr,t,ADDRESS    \
			    -C c,6,$l_t02_max_city,$l_t02_max_city,t,CITY       \
			    -C c,7,$l_t02_max_stat,$l_t02_max_stat,zt,STATE     \
			    -C c,8,$l_t02_max_zipc,$l_t02_max_zipc,t,ZIP_CODE   \
			    -o "$l_t02_ofile" "$l_t02_ifile"        \
		    >> "$l_t02_vfile" 2>&1
	l_t02_ecode="$?"
    else
	f_msg "IT02_03: START ./jr, Test 2 $MSG_MEMORY"
	$OPENBSD_KTRACE ./jr -d 124 -vf -r "$l_t02_rfile" -e "$l_t02_efile"  \
	    -C c,1,$l_t02_max_uppr,$l_t02_max_uppr,t,NAME_UPP   \
	    -C c,2,$l_t02_max_name,$l_t02_max_name,t,NAME       \
	    -C c,3,$l_t02_max_coun,$l_t02_max_coun,t,COUNTRY    \
	    -C c,4,$l_t02_max_addi,$l_t02_max_addi,t,ADD_INFO   \
	    -C c,5,$l_t02_max_addr,$l_t02_max_addr,t,ADDRESS    \
	    -C c,6,$l_t02_max_city,$l_t02_max_city,t,CITY       \
	    -C c,7,$l_t02_max_stat,$l_t02_max_stat,zt,STATE     \
	    -C c,8,$l_t02_max_zipc,$l_t02_max_zipc,t,ZIP_CODE   \
	    -o "$l_t02_ofile" "$l_t02_ifile"
	l_t02_ecode="$?"
    fi

    if test "$l_t02_ecode" -ne "0"
    then
	f_msg "ET02_10: FAILED Test 2, $l_t02_ofile"
    fi

    f_msg "IT02_20: Created $l_t02_ofile"
    f_msg "IT02_21:         $l_t02_efile"
    if test -f "$l_t02_vfile"
    then
	f_msg "IT02_22:         $l_t02_vfile"
    fi
    if test "$OPENBSD_KTRACE" != ""
    then
	sleep 1
	kdump -u malloc
	sleep 1
	f_msg "It02_30: ***** Execute this:"
	f_msg "It02_31:       addr2line -e ./jr 0x????"
	f_msg "It02_32: ***** using the last hex val on the line for ./jr"
	f_msg "It02_33: ***** to see where the leak is (if any)"
    fi
    f_msg "IT02_40: END   ./jr, Test 2 $MSG_MEMORY"

} # END: f_test_02()

#
# f_test_03()
#
f_test_03()
{
    l_t03_ifile=$g_dir_in/t03_ifile.txt
    l_t03_ofile=$DIR_RESULTS/val-t03.out
    l_t03_rfile=$DIR_RESULTS/val-t03.rpt
    l_t03_efile=$DIR_RESULTS/val-t03.err
    l_t03_vfile=$DIR_RESULTS/valgrind_t03.err
    l_t03_ecode="0"

    f_msg "IT03_01: Creating $l_t03_ofile"

    rm "$l_t03_vfile" > /dev/null 2>&1
    if test "$PROCESS_VALGRIND" = "Y"
    then
	f_msg "IT03_02: START ./jr, Test 3 $MSG_MEMORY"
	valgrind -s --tool=memcheck --leak-check=yes        \
		    --leak-check=full --show-leak-kinds=all \
		    --track-origins=yes                     \
		    --keep-stacktraces=alloc-then-free      \
			./jr -f -d 124 -g s,5 -G 1 -vvvvv  \
			     -r "$l_t03_rfile" -e "$l_t03_efile" -o "$l_t03_ofile"  \
			     -C d,1,10,8,t,"START_DATE"                             \
			     -C c,2,6,6,t,"START_TIME"                              \
			     -C d,3,10,8,t,"END_DATE"                               \
			     -C c,4,6,6,t,"END_TIME"                                \
			     -C c,5,30,30,t,"RUN_STATUS" < $l_t03_ifile             \
		     >> "$l_t03_vfile" 2>&1
	l_t03_ecode="$?"
    else
	f_msg "IT03_03: START ./jr, Test 3  $MSG_MEMORY"
	cat $l_t03_ifile | $OPENBSD_KTRACE ./jr -f -d 124 -g s,5 -G 1 -vvvvv  \
	     -r "$l_t03_rfile" -e "$l_t03_efile"              \
	     -C d,1,10,8,t,"START_DATE"                       \
	     -C c,2,6,6,t,"START_TIME"                        \
	     -C d,3,10,8,t,"END_DATE"                         \
	     -C c,4,6,6,t,"END_TIME"                          \
	     -C c,5,30,30,t,"RUN_STATUS" > "$l_t03_ofile"
	l_t03_ecode="$?"
    fi

    if test "$l_t03_ecode" -ne "0"
    then
	f_msg "ET03_10: FAILED Test 3, $l_t03_ofile"
    fi

    f_msg "IT03_20: Created $l_t03_ofile"
    f_msg "IT03_21:         $l_t03_efile"
    if test -f "$l_t03_vfile"
    then
	f_msg "IT03_22:         $l_t03_vfile"
    fi
    if test "$OPENBSD_KTRACE" != ""
    then
	sleep 1
	kdump -u malloc
	sleep 1
	f_msg "It03_30: ***** Execute this:"
	f_msg "It03_31:       addr2line -e ./jr 0x????"
	f_msg "It03_32: ***** using the last hex val on the line for ./jr"
	f_msg "It03_33: ***** to see where the leak is (if any)"
    fi
    f_msg "IT03_40: END   ./jr, Test 3 $MSG_MEMORY"

} # END: f_test_03()

#
# f_test_04()
#
f_test_04()
{
    l_t04_ifile=$g_dir_in/t04_ifile.txt
    l_t04_ofile=$DIR_RESULTS/val-t04.out
    l_t04_rfile=$DIR_RESULTS/val-t04.rpt
    l_t04_efile=$DIR_RESULTS/val-t04.err
    l_t04_vfile=$DIR_RESULTS/valgrind_t04.err
    l_t04_ecode="0"

    f_msg "IT04_01: Creating $l_t04_ofile"

    rm "$l_t04_vfile" > /dev/null 2>&1
    if test "$PROCESS_VALGRIND" = "Y"
    then
	f_msg "IT04_02: START ./jr, Test 4 $MSG_MEMORY - option $TEST_ARG"
	valgrind -s --tool=memcheck --leak-check=yes        \
		    --leak-check=full --show-leak-kinds=all \
		    --track-origins=yes                     \
		    --keep-stacktraces=alloc-then-free      \
			./jr -f -vvvvv -D 124                  \
	                     -g $g_date_ifmt -G $g_date_ofmt   \
			     -r "$l_t04_rfile"                 \
	                     -e "$l_t04_efile"                 \
	                     -o "$l_t04_ofile"                 \
			     -C d,1,8,10,t,"START_DATE"        \
			     -C c,9,6,6,t,"START_TIME"         \
			     -C d,15,8,10,t,"END_DATE"         \
			     -C c,23,6,6,t,"END_TIME"          \
			     -C c,29,30,30,t,"RUN_STATUS" < $l_t04_ifile            \
		     >> "$l_t04_vfile" 2>&1
	l_t04_ecode="$?"
    else
	f_msg "IT04_04: START ./jr, Test 4  $MSG_MEMORY - option $TEST_ARG"
	cat $l_t04_ifile | $OPENBSD_KTRACE ./jr -f   \
	     -vvvvv -D 124                           \
	     -g $g_date_ifmt -G $g_date_ofmt         \
	     -r "$l_t04_rfile" -e "$l_t04_efile"     \
	     -C d,1,8,10,t,"START_DATE"              \
	     -C c,9,6,6,t,"START_TIME"               \
	     -C d,15,8,10,t,"END_DATE"               \
	     -C c,23,6,6,t,"END_TIME"                \
	     -C c,29,30,30,t,"RUN_STATUS"            \
             > "$l_t04_ofile"
	l_t04_ecode="$?"
    fi

    if test "$l_t04_ecode" -ne "0"
    then
	f_msg "ET04_10: FAILED Test 4, $l_t04_ofile"
    fi

    f_msg "IT04_20: Created $l_t04_ofile"
    f_msg "IT04_21:         $l_t04_efile"
    if test -f "$l_t04_vfile"
    then
	f_msg "IT04_22:         $l_t04_vfile"
    fi
    if test "$OPENBSD_KTRACE" != ""
    then
	sleep 1
	kdump -u malloc
	sleep 1
	f_msg "It04_30: ***** Execute this:"
	f_msg "It04_31:       addr2line -e ./jr 0x????"
	f_msg "It04_32: ***** using the last hex val on the line for ./jr"
	f_msg "It04_33: ***** to see where the leak is (if any)"
    fi
    f_msg "IT04_40: END   ./jr, Test 4 $MSG_MEMORY - option $TEST_ARG"

} # END: f_test_04()

#
# main
#
g_rmode=""
g_dir_in="$TEST_DIR_SRC/test_data"
g_test_memory="N"
g_test_kdump="N"
g_test01="Y"
g_test02="Y"
g_test03="Y"
g_test04="Y"
g_date_ifmt=""
g_date_ofmt=""

cd $TEST_DIR_SRC
f_ckdir "r" "$g_dir_in"
f_ckprog ./jr

case "$TEST_ARG" in
    "-s")  # uses file t01_ifile.txt
	g_test01="Y"
	g_test02="N"
	g_test03="N"
	g_test04="N"
	;;
    "-L")  # uses file t02_ifile.txt
	g_test01="N"
	g_test02="Y"
	g_test03="N"
	g_test04="N"
	;;
    "-d")  # uses file t03_ifile.txt
	g_test01="N"
	g_test02="N"
	g_test03="Y"
	g_test04="N"
	;;
    "-DD")  # uses file t04_ifile.txt
	g_test01="N"
	g_test02="N"
	g_test03="N"
	g_test04="Y"
	g_date_ifmt="1"
	g_date_ofmt="6,d"
	;;
    "-MM")  # uses file t04_ifile.txt
	g_test01="N"
	g_test02="N"
	g_test03="N"
	g_test04="Y"
	g_date_ifmt="1"
	g_date_ofmt="5,s"
	;;
    *)
	echo ""
	g_is_error="Y"
	f_help_setup
	f_msg "W010: Required test option missing or invalid, exiting"
	exit 2
	;;
esac

#--- print version info
./jr -V > "$FILE_VERSION_RESULTS" 2>&1
cat << EOF >> $FILE_MAKE_RESULTS 2>&1
=====================================================================
Source  Dir: $TEST_DIR_SRC
Results Dir: $DIR_RESULTS

Program Rev:
---------------------------------------------------------------------
`cat $FILE_VERSION_RESULTS`
=====================================================================
EOF

#--- clean up files
rm $FILE_VERSION_RESULTS $FILE_VALGRIND_LOG > /dev/null 2>&1
if test -d "$DIR_RESULTS"
then
    find $DIR_RESULTS -type f -name 'val*' -exec rm '{}' \;
fi

#--- process test
if test "$g_test01" = "Y"
then
    f_test_01
fi
if test "$g_test02" = "Y"
then
    f_test_02
fi
if test "$g_test03" = "Y"
then
    f_test_03
fi

if test "$g_test04" = "Y"
then
    f_test_04
fi

#------------------------------------------------------------------------------
# done
#------------------------------------------------------------------------------
exit 0
