#!/bin/sh
#
# jmerge - test with valgrind or ktrace
#
# Copyright (c) 2022 ... 2025 2026
#     John McCue <jmccue@sdf.org>
#
# Permission to use, copy, modify, and distribute this software
# for any purpose with or without fee is hereby granted, provided
# that the above copyright notice and this permission notice
# appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
# WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
# LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

g_dir_bhome=`dirname $0`
cd $g_dir_bhome
g_dir_bhome=`pwd`
. $g_dir_bhome/../test/tsetup.sh

g_file_headers="$TEST_DIR_SRC/test_data/headers.txt"
g_file_items="$TEST_DIR_SRC/test_data/items.txt"
g_file_in_1="$DIR_RESULTS/val_file_in_1.txt"
g_file_in_2="$DIR_RESULTS/val_file_in_2.txt"
g_file_out="$DIR_RESULTS/val_out.txt"
g_file_out_err="$DIR_RESULTS/val_out_err.txt"
g_file_out_jmerge="$DIR_RESULTS/val_out_jmerge.txt"
g_file_out_join="$DIR_RESULTS/val_out_join.txt"
g_file_out_stat="$DIR_RESULTS/val_out_stats.txt"
g_temp_in_1="$DIR_RESULTS/temp_in_1.txt"
g_temp_in_2="$DIR_RESULTS/temp_in_2.txt"

g_sort_files="Y"

case "$TEST_ARG" in
    "-s")
	g_sort_files="Y"
	g_arg_sort=""
	;;
    "-r")
	g_sort_files="N"
	g_arg_sort="-u"
	;;
    *)
	echo ""
	g_is_error="Y"
	f_help_setup
	f_msg "W010: Required test option missing or invalid, exiting"
	exit 2
	;;
esac

cd $TEST_DIR_SRC

#--- checks
f_ckprog "$PROG_SHUFFLE"
f_ckprog join
f_ckprog ./jmerge
f_ckfile "r" "$g_file_headers"
f_ckfile "r" "$g_file_items"

#--- create input files
rm "$g_temp_in_1" "$g_temp_in_2" "$g_file_out_err" > /dev/null 2>&1
rm "$g_file_out" "$g_file_out_jmerge" "$g_file_out_join" > /dev/null 2>&1

f_msg "I100: Creating Test Files"
if test "$g_sort_files" = "Y"
then
    grep -v '^ORDER|' < $g_file_headers | sort > "$g_file_in_1"
    grep -v '^ORDER|' < $g_file_items   | sort > "$g_file_in_2"
    f_msg "I101: Processing Sorted Data"
else
    grep -v '^ORDER|' < $g_file_headers | $PROG_SHUFFLE > "$g_file_in_1"
    grep -v '^ORDER|' < $g_file_items   | $PROG_SHUFFLE > "$g_file_in_2"
    f_msg "I102: Processing Random Ordered Data"
fi

#--- print version info
./jmerge -V > "$FILE_VERSION_RESULTS" 2>&1
cat << EOF >> $FILE_MAKE_RESULTS 2>&1
=====================================================================
Source  Dir: $TEST_DIR_SRC
Results Dir: $DIR_RESULTS

Program Rev:
---------------------------------------------------------------------
`cat $FILE_VERSION_RESULTS`
=====================================================================
EOF
rm $FILE_VERSION_RESULTS $FILE_VALGRIND_LOG > /dev/null 2>&1

#--- Test object
if test "$PROCESS_VALGRIND" = "Y"
then
    f_msg "A220: START ./jmerge $MSG_MEMORY"   >> "$FILE_VALGRIND_LOG"
    f_msg "I223: START ./jmerge $MSG_MEMORY"
    valgrind -s --tool=memcheck --leak-check=yes                   \
                --leak-check=full --show-leak-kinds=all            \
                --track-origins=yes                                \
                --keep-stacktraces=alloc-then-free                 \
                ./jmerge $g_arg_sort -f -d 124       \
		         -vvv -e $g_file_out_err     \
		         -o $g_file_out              \
		         -K $g_file_out_stat         \
			 -i $g_file_in_1 $g_file_in_2 \
                >> "$FILE_VALGRIND_LOG" 2>&1
    if test "$TERM" = "dumb"
    then
	cat $FILE_VALGRIND_LOG
    fi
    f_msg "I230: Created: $FILE_VALGRIND_LOG"
    f_msg "I231:        : $g_file_out"
    f_msg "I232:        : $g_file_out_err"
    f_msg "I233:        : $g_file_out_stat"
    f_msg "B241: END   ./jmerge $MSG_MEMORY"
    f_msg "B242: END   ./jmerge $MSG_MEMORY" >> "$FILE_VALGRIND_LOG"
else
    f_msg "I340: START ./jmerge $MSG_MEMORY"
    $OPENBSD_KTRACE ./jmerge $g_arg_sort -f -d 124 -vvv  -e $g_file_out_err \
	     -o $g_file_out -i $g_file_in_1 -K $g_file_out_stat $g_file_in_2
    f_msg "I351: Created: $g_file_out"
    f_msg "I352:        : $g_file_out_err"
    f_msg "I353:        : $g_file_out_stat"
    if test "$OPENBSD_KTRACE" != ""
    then
	sleep 1
	kdump -u malloc
	sleep 1
	f_msg "I354: ***** Execute this:"
	f_msg "I355:       addr2line -e ./jmerge 0x????"
	f_msg "I356: ***** using the last hex val on the line for ./jmerge"
	f_msg "I357: ***** to see where the leak is (if any)"
    fi
    f_msg "I360: END   ./jmerge $MSG_MEMORY"
fi

#--- check test results
f_msg "I401: compare join(1) to jmerge output"
grep '^MATCHED' < "$g_file_out" \
    | sed 's/MATCHED:  //'     \
    | awk -F '|' '{printf("%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s\n",$1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$13,$14,$15,$16,$17,$18,$19,$20,$21,$22,$23,$24,$25,$26)}' \
    | sort > "$g_file_out_jmerge"
if test "$g_sort_files" = "Y"
then
    join -t '|' $g_file_in_1 $g_file_in_2 > "$g_file_out_join"
else
    sort $g_file_in_1 > $g_temp_in_1
    sort $g_file_in_2  > $g_temp_in_2
    join -t '|' $g_temp_in_1 $g_temp_in_2 > "$g_file_out_join"
    rm "$g_temp_in_1" "$g_temp_in_2" > /dev/null 2>&1
fi

diff "$g_file_out_jmerge"  "$g_file_out_join" > /dev/null 2>&1
if test "$?" -eq "0"
then
    f_msg "I410: SUCCESS ./jmerge vs join(1)"
else
    f_msg "W420: FAILED ./jmerge vs join(1)"
    f_msg "W421: See Files:"
    f_msg "W422    $g_file_out_join"
    f_msg "E423    $g_file_out_jmerge"
fi

exit 0
