#!/bin/sh
#
# jhead - test with valgrind or ktrace
#
# Copyright (c) 2022 ... 2025 2026
#     John McCue <jmccue@sdf.org>
#
# Permission to use, copy, modify, and distribute this software
# for any purpose with or without fee is hereby granted, provided
# that the above copyright notice and this permission notice
# appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
# WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
# LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

g_dir_bhome=`dirname $0`
cd $g_dir_bhome
g_dir_bhome=`pwd`
. $g_dir_bhome/../test/tsetup.sh

#
# main
#

g_file_err=$DIR_RESULTS/val_err.txt
g_file_out=$DIR_RESULTS/val_out.txt
g_temp_out_jhead=$DIR_RESULTS/val_out_jhead.txt
g_temp_out_head=$DIR_RESULTS/val_out_head.txt

cd $TEST_DIR_SRC
f_ckprog ./jhead
f_ckfile 'r' $TEST_DIR_SRC/jhead.c

#--- print version info
./jhead -V > "$FILE_VERSION_RESULTS" 2>&1
cat << EOF >> $FILE_MAKE_RESULTS 2>&1
=====================================================================
Source  Dir: $TEST_DIR_SRC
Results Dir: $DIR_RESULTS

Program Rev:
---------------------------------------------------------------------
`cat $FILE_VERSION_RESULTS`
=====================================================================
EOF
rm $FILE_VERSION_RESULTS $FILE_VALGRIND_LOG > /dev/null 2>&1

f_msg "I100: Will Extract Records 10 -- 20"

#--- Test object
if test "$PROCESS_VALGRIND" = "Y"
then
    f_msg "A201: START ./jhead $MSG_MEMORY" > "$FILE_VALGRIND_LOG"
    f_msg "I202: START ./jhead $MSG_MEMORY"
    valgrind -s --tool=memcheck --leak-check=yes        \
                --leak-check=full --show-leak-kinds=all \
                --track-origins=yes                     \
                --keep-stacktraces=alloc-then-free      \
	        ./jhead -vvv -f -e $g_file_err -o $g_file_out -S 10 -E 20 -c jhead*.c \
                >> "$FILE_VALGRIND_LOG" 2>&1
    if test "$TERM" = "dumb"
    then
	cat $FILE_VALGRIND_LOG
    fi
    f_msg "I281: Created: $FILE_VALGRIND_LOG"
    f_msg "I282:          $g_file_out"
    f_msg "I283:          $g_file_err"
    f_msg "I290: END   ./jhead $MSG_MEMORY"
    f_msg "B291: END   ./jhead $MSG_MEMORY"     >> "$FILE_VALGRIND_LOG"
else
    f_msg "I300: START ./jhead $MSG_MEMORY"
    $OPENBSD_KTRACE ./jhead -vvv -f -e $g_file_err -o $g_file_out -S 10 -E 20 -c jhead*.c
    f_msg "I301: Created: $g_file_out"
    f_msg "I302:          $g_file_err"
    if test "$OPENBSD_KTRACE" != ""
    then
	sleep 1
	kdump -u malloc
	sleep 1
	f_msg "I313: ***** Execute this:"
	f_msg "I314:       addr2line -e ./jhead 0x????"
	f_msg "I315: ***** using the last hex val on the line for ./jhead"
	f_msg "I316: ***** to see where the leak is (if any)"
    fi
    f_msg "I320: END   ./jhead $MSG_MEMORY"
fi

#--- validate
head  $TEST_DIR_SRC/jhead.c > "$g_temp_out_head"
jhead $TEST_DIR_SRC/jhead.c > "$g_temp_out_jhead"

diff "$g_temp_out_jhead" "$g_temp_out_head" > /dev/null 2>&1
if test "$?" -eq "0"
then
    rm "$g_temp_out_jhead" "$g_temp_out_head"
    f_msg "I401: SUCCESS ./jhead vs head(1)"
else
    f_msg "W402: FAILED  ./jhead vs head(1)"
    f_msg "W403: See Files:"
    f_msg "W404    $g_temp_out_jhead"
    f_msg "E405    $g_temp_out_head"
fi

exit 0
