/*
 * Copyright (c) 2007 ... 2025 2026
 *     John McCue <jmccue@sdf.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _MSDOS
#include <sys/param.h>
#endif
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef HAVE_JLIB
#include <j_lib2.h>
#include <j_lib2m.h>
#endif

#include "jhead.h"

#define MSG_HELP_11 "Show first n lines of a text file"

/*
 * show_rev() -- Show Module Revisions
 */
void show_rev()

{

  fprintf(stderr,"%s: %s\n", PROG_NAME, MSG_HELP_11);

#ifdef J_LIB2_H
  fprintf(stderr, "\t%s\n", j2_get_build());
#endif

  fprintf(stderr, "\t%s %s: %s - ", LIT_REV, PROG_NAME, JHEAD_H_REV);
  fprintf(stderr, LIT_INFO_04, __DATE__, __TIME__);

#ifdef OSTYPE
  fprintf(stderr,"\t%s\n",OSTYPE);
#endif  /* OSTYPE  */
#ifdef PRETTY_NAME
  fprintf(stderr,"\t%s\n",PRETTY_NAME);
#endif  /* PRETTY_NAME  */

  exit(EXIT_FAILURE);

} /* show_rev() */

/*
 * show_brief_help() -- Show Brief help
 */
void show_brief_help()

{

  fprintf(stderr, USG_MSG_USAGE, PROG_NAME);
  fprintf(stderr, "\t%s\n", MSG_HELP_11);
  fprintf(stderr, USG_MSG_OPTIONS);
  fprintf(stderr, USG_MSG_ARG_COUNT,       SWITCH_CHAR, ARG_COUNT);
  fprintf(stderr, USG_MSG_ARG_END_1,       SWITCH_CHAR, ARG_END);
  fprintf(stderr, USG_MSG_ARG_ERR,         SWITCH_CHAR, ARG_ERR);
  fprintf(stderr, USG_MSG_ARG_FORCE,       SWITCH_CHAR, ARG_FORCE);

  fprintf(stderr, USG_MSG_ARG_HELP,        SWITCH_CHAR, ARG_HELP);
  fprintf(stderr, USG_MSG_ARG_NUMB,        SWITCH_CHAR, ARG_NUMB, HEAD_LINES_DEFAULT);
  fprintf(stderr, USG_MSG_ARG_OUT,         SWITCH_CHAR, ARG_OUT);
  fprintf(stderr, USG_MSG_ARG_START_1,     SWITCH_CHAR, ARG_START, HEAD_LINES_START);
  fprintf(stderr, USG_MSG_ARG_VERBOSE_8,   SWITCH_CHAR, ARG_VERBOSE);
  fprintf(stderr, USG_MSG_ARG_VERSION,     SWITCH_CHAR, ARG_VERSION);

  exit(EXIT_FAILURE);

} /* show_brief_help() */
