.\"
.\" Copyright (c) 2007 ... 2025 2026
.\"     John McCue <jmccue@sdf.org>
.\"
.\" Permission to use, copy, modify, and distribute this software
.\" for any purpose with or without fee is hereby granted,
.\" provided that the above copyright notice and this permission
.\" notice appear in all copies.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
.\" WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
.\" THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
.\" CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
.\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\" SOFTWARE.
.\"
.TH JHEAD 1 "2007-11-08" "JMC" "Local Command"
.SH NAME
jhead - output the first part of 1 or more files to stdout
.SH SYNOPSIS
jhead [OPTIONS] [FILE...]
.SH DESCRIPTION
Print 10 lines of each FILE to standard output
of file name(s) supplied.
If processing more than one FILE, precede each with a header
showing the file name.
Will default to print the first 10 lines,
but OPTIONS can be used to change the default behaviour.
.PP
If no files (FILE) are specified on the command line or
if FILE has name "-", stdin (Standard Input) is used.
.TP
-c
Prefix output with line number.
.TP
-E LINE
End line count and printing at this LINE number.
Default is to show 10 lines.  (See -n below).
.TP
-e file
Write errors/stats to file 'file'.
Default is to to use stderr.
If file exists abort unless '-f' supplied (see below).
.TP
-f
If creating an Output Files (see -e/-o), overwrite
file if it exists, default is to abort if output exists
.TP
-h
Show brief help and exit.
.TP
-n NUMBER
Print 'NUMBER' lines instead of the default of 10 lines.
.TP
-o file
Write output to file 'file'.
Default is to to use stdout.
If file exists abort unless '-f' supplied (see above).
.TP
-S LINE
Start line count and printing at this LINE number.
Will print default of 10 lines or 'NUMBER' lines (see above)
from this line forward
.TP
-V
Output version information and exit.
.TP
-v
Verbose Level,
print information about the run.
Default do not show run messages.
Can be specified multiple times,
each specification increases verbose level:
.nf
    Level  Meaning
    -----  ---------------------------------------
    = 0    Do not show any information, default
    >= 1   Show File I/O stats on stderr
    >= 2   Show arguments on stderr
    >= 3   Show headings on stdout as each file
           is processed
.fi
.SH ENVIRONMENT
Environment variable 'ARG_JHEAD_N' can be set to set
the default number of lines printed (-n).
Command line will override this variable.
.SH DIAGNOSTICS
Unlike 'head(1)', only '-n #' is supported,
shortcut option '-#' is not supported.
.PP
Only supports text files.
Processing binary files can return unexpected results.
.PP
If available, head(1) may have more options
and will be faster.
.SH SEE-ALSO
dd(1),
head(1),
j(1),
jascii(1),
jtail(1),
tail(1)
.SH ERROR-CODES
.nf
0 success
1 processing error or help/rev displayed
.fi
