/*
 * Copyright (c) 2007 ... 2025 2026
 *     John McCue <jmccue@sdf.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef JHEAD_H_REV

#define JHEAD_H_REV "3.15 2025/08/16"
#define PROG_NAME   "jhead"

#define ARG_JHEAD_N    "ARG_JHEAD_N"

#define HEAD_LINES_DEFAULT 10L
#define HEAD_LINES_START   1L

#ifndef JLIB2_CHAR_NULL
#define NO_JLIB 1
#define JLIB2_INT_NULL   ((int) '\0')
#define JLIB2_CHAR_NULL  ((char) '\0')
#define JLIB2_UCHAR_NULL ((unsigned char) '\0' )
#endif

#ifndef NULL
#define NULL '\0'
#endif
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#ifndef SSIZE_T
#define SSIZE_T ssize_t
#endif
#ifndef TAB_CHAR
#define TAB_CHAR 0x09
#endif

#ifdef MAXPATHLEN
#ifndef PATH_MAX
#define PATH_MAX MAXPATHLEN
#endif
#else
#ifdef PATH_MAX
#define MAXPATHLEN PATH_MAX
#endif
#endif

#define PATH_IS_VALID   0
#define PATH_IS_NULL    1
#define PATH_IS_EMPTY   2
#define PATH_IS_BIG     3
#define PATH_HAS_SPACE  4
#define PATH_INVALID    5

/*** messages ***/
#ifdef NO_JLIB
#define ARG_COUNT          'c'  /* Prefix output with line number     */
#define ARG_END            'E'  /* End Line Number                    */
#define ARG_ERR            'e'  /* Output Error File                  */
#define ARG_FORCE          'f'  /* force create files                 */
#define ARG_HELP           'h'  /* Show Help                          */
#define ARG_NUMB           'n'  /* # of lines to print                */
#define ARG_OUT            'o'  /* Output File                        */
#define ARG_QUIET          'q'  /* Quiet Mode                         */
#define ARG_START          'S'  /* start print at line #              */
#define ARG_VERBOSE        'v'  /* Verbose                            */
#define ARG_VERSION        'V'  /* Show Version Information           */

#define FILE_NAME_STD      "-"
#define SWITCH_CHAR        '-'

#define LIT_C80            "::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::"
#define LIT_INFO_04        "Build: %s %s\n"
#define LIT_NO             "No"
#define LIT_NULL           "<null>"
#define LIT_REV            "Revision"
#define LIT_STDERR         "(standard error)"
#define LIT_STDIN          "(standard input)"
#define LIT_STDOUT         "(standard output)"
#define LIT_YES            "Yes"

#define MSG_ERR_E000       "Try '%s %c%c' for more information\n"
#define MSG_ERR_E002       "ERROR E002: Cannot open '%s' for write, processing aborted\n"
#define MSG_ERR_E004S      "ERROR E004: value '%s' invalid value for %c%c\n"
#define MSG_ERR_E004SB     "ERROR E004: value '%s' value for %c%c too large\n"
#define MSG_ERR_E006       "ERROR E006: '%s' is an invalid value for %c%c\n"
#define MSG_ERR_E025       "ERROR E025: File %s cannot be created, already exists\n"
#define MSG_ERR_E074       "ERROR E074: 'Too many Arguments specified for %c%c\n"
#define MSG_ERR_E111       "ERROR E111: Start Line (%lld) > End Line (%lld)\n"
#define MSG_ERR_E112       "ERROR E112: cannot open %s, already opened\n"
#define MSG_ERR_E113       "ERROR E113: stdin can only be used once\n"

#define MSG_INFO_I043L     "I043: Input  File                  : %s\n"
#define MSG_INFO_I072      "I072:    Lines Reads:  %9ld - File %s\n"
#define MSG_INFO_I080      "I080:   Lines Writes:  %9ld - File %s\n"
#define MSG_INFO_I081      "I081: Number of Input Files        : %d\n"
#define MSG_INFO_I086      "I086: Errors written to file       : %s\n"
#define MSG_INFO_I087      "I087: Force Create Output          ? %s\n"
#define MSG_INFO_I090      "I090: Output written to file       : %s\n"
#define MSG_INFO_I092      "I092: Verbose Level                : %d\n"
#define MSG_INFO_I152S     "I152: Run Time: %lld second(s)\n"
#define MSG_INFO_I162      "I162: Prefix Output with Line #    : %s\n"
#define MSG_INFO_I163      "I163: Start Print at Line Number   : %lld\n"
#define MSG_INFO_I164      "I164: End Print at Line Number     : %lld\n"
#define MSG_INFO_I165      "I165: Number of Lines to Print     : %lld\n"

#define MSG_WARN_W002      "W002: Open Error Bypass File '%s' : %s\n"

#define USG_MSG_OPTIONS        "Options\n"
#define USG_MSG_USAGE          "usage:\t%s [OPTIONS] [FILES ...]\n"
#define USG_MSG_ARG_COUNT      "\t%c%c\t\t: prefix output with line number\n"
#define USG_MSG_ARG_END_1      "\t%c%c #\t\t: End display at line '#'\n"
#define USG_MSG_ARG_ERR        "\t%c%c file\t\t: Write errors to file 'file', default stderr\n"
#define USG_MSG_ARG_FORCE      "\t%c%c\t\t: force create of files when found\n"
#define USG_MSG_ARG_HELP       "\t%c%c\t\t: Show brief help and exit\n"
#define USG_MSG_ARG_NUMB       "\t%c%c #\t\t: Display '#' lines, default is to display %ld lines\n"
#define USG_MSG_ARG_OUT        "\t%c%c file\t\t: Write output to file 'file', default stdout\n"
#define USG_MSG_ARG_QUIET_2    "\t%c%c\t\t: do not show file headings.\n"
#define USG_MSG_ARG_START_1    "\t%c%c #\t\t: Start display at line '#', default is line %ld\n"
#define USG_MSG_ARG_VERBOSE_8  "\t%c%c\t\t: verbose level, each time specified level increases\n"
#define USG_MSG_ARG_VERSION    "\t%c%c\t\t: Show revision information and exit\n"

#endif /* NO_JLIB */

/*** Structures ***/
struct s_file_info
{
  FILE *fp;
  char fname[(PATH_MAX + 1)];
  int ok_to_close;
} ;

typedef struct
{
  int  num_files;
  int  force;                  /* TRUE or FALSE, defaults to FALSE */
  int  verbose;                /* Verbose level                    */
  int  show_ln;                /* TRUE or FALSE, defaults to FALSE */
  long int  start_line;        /* Start at this line number        */
  long int  end_line;          /* End   at this line number        */
  long int  show_lines;        /* Lines to display                 */
  long int  lines_written;     /* Lines Printed                    */
  struct s_file_info out;
  struct s_file_info err;
}  work_area;

/*** Prototypes ***/
void process_arg(int, char **, work_area *);
void init(work_area *, int, char **);
void show_rev();
void show_brief_help();
void init_finfo(struct s_file_info *);
void open_out(struct s_file_info *, char *, int);
void close_file(struct s_file_info *);

#ifdef NO_JLIB
SSIZE_T j2_getline(char **buf, size_t *n, FILE *fp);
int j2_f_exist(char *file_name);
long int j2_clr_str(char *s, char c, int size);
int j2_is_numr(char *s);
#endif /* NO_JLIB */

#endif /* JHEAD_H_REV */
