#!/bin/sh
#
# test script for jgrep
#
#
# Copyright (c) 2022 ... 2025 2026
#     John McCue <jmccue@sdf.org>
#
# Permission to use, copy, modify, and distribute this software
# for any purpose with or without fee is hereby granted, provided
# that the above copyright notice and this permission notice
# appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
# WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
# LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

g_dir_bhome=`dirname $0`
cd $g_dir_bhome
g_dir_bhome=`pwd`
. $g_dir_bhome/../test/tsetup.sh

#
# f_get_random() - Get a Random Rec # from File $g_file_search
#
f_get_random()
{
    l_gr_digit_count=""
    l_gr_bytes=""
    l_gr_count_recs=""

    l_gr_count_recs=`wc -l < "$g_file_search" | sed 's/ //g'`

    #--- If jrandom is installed, use that, much faster
    type jrandom > /dev/null 2>&1
    if test "$?" -eq "0"
    then
	g_rec_search=`jrandom -L 1 -M $l_gr_count_recs -m 1`
	return
    fi

    #--- get a random number <= # of Records in $g_file_search
    #    using base tools
    l_gr_bytes=`wc -l < "$g_file_search" | sed 's/ //g' | wc -c | sed 's/ //g'`
    l_gr_digit_count=`expr "$l_gr_bytes" - 1` # remove new line

    while test 1
    do
	g_rec_search=`tr -cd '[:digit:]' < /dev/urandom | fold -w $l_gr_digit_count | sed 1q | sed 's/^0*//'`
	if test "$g_rec_search" -le "$l_gr_count_recs"
	then
	    break
	fi
    done

} # END: f_get_random()

#
# main
#

#--- checks
f_ckdir  "x" "$DIR_RESULTS"

#--- setup variables and file locations
g_file_in="$DIR_RESULTS/val-in.txt"
g_file_in_delm="$DIR_RESULTS/val-delm.txt"
g_file_search="$DIR_RESULTS/val-search.txt"
g_file_grep="$DIR_RESULTS/grep.txt"
g_file_diff="$DIR_RESULTS/diff.txt"
g_file_out="$DIR_RESULTS/val-out.txt"
g_sort_out="$DIR_RESULTS/val-out_sorted.txt"
g_file_err="$DIR_RESULTS/val-err.txt"
g_temp_01="$DIR_RESULTS/temp-01.txt"
g_temp_02="$DIR_RESULTS/temp-02.txt"
g_temp_03="$DIR_RESULTS/temp-03.txt"
g_file_in_use="$g_file_in"
g_lines=0
g_cut_col_1=0
g_cut_col_2=0
g_rc=0
g_files_where_created="N"
g_arg_search=""
g_arg_delm=""
g_arg_col=""
g_arg_invert=""

#--- Test Flags to change manually
#g_arg_quiet="-q"
#g_arg_slow="-r 1000 -s 1"
g_arg_verbose="-vvv"

#--- checks
cd $TEST_DIR_SRC
f_ckprog $PROG_SHUFFLE
f_ckprog ./jgrep

#--- Set Test Flags
case "$TEST_ARG" in
    "T01")      # Search for 1 specific entry
	;;
    "T02")      # Inverse Search for 1 specific entry
	g_arg_invert="-R"
	;;
    "T03")      # Search for entries from a file
	g_arg_search="-p $g_file_search"
	;;
    "T04")      # Reverse Search for entries from a file
	g_arg_search="-p $g_file_search"
	g_arg_invert="-R"
	;;
    "T11")      # Search for 1 specific entry in Delimited Column 2
	g_arg_delm="-C 2 -d 124"
	;;
    "T12")      # Search for entries from a file in Delimited Column 2
	g_arg_search="-p $g_file_search"
	g_arg_delm="-C 2 -d 124"
	;;
    "T13")      # Reverse Search for 1 specific entry in Delimited Column 2
	g_arg_delm="-C 2 -d 124"
	g_arg_invert="-R"
	;;
    "T14")      # Reverse Search for entries from a file in Delimited Column 2
	g_arg_search="-p $g_file_search"
	g_arg_delm="-C 2 -d 124"
	g_arg_invert="-R"
	;;
    "T21")      # Search for 1 specific entry at char # 4
	g_arg_col="-C 4"
	;;
    "T22")      # Search for entries from a file at char # 4
	g_arg_search="-p $g_file_search"
	g_arg_col="-C 4"
	;;
    "T23")      # Reverse Search for 1 specific entry at char # 4
	g_arg_col="-C 4"
	g_arg_invert="-R"
	;;
    "T24")      # Search for entries from a file at char # 4
	g_arg_search="-p $g_file_search"
	g_arg_col="-C 4"
	g_arg_invert="-R"
	;;
    "-h"|"--help"|"-H"|"--HELP"|"help"|"HELP")
	f_help
	;;
    *)
	echo ""
	g_is_error="Y"
	f_help_setup
	f_msg "W010: Required test option missing or invalid, exiting"
	exit 2
	;;
esac


#--- no need to change from here down
g_rec_search=""
g_use_search_file="Y"

#--- Create Input Files
if test -r "$g_file_in"
then
    if test "`wc -l < $g_file_in | sed 's/ //g'`" -lt "100"
    then
	f_rmfile "$g_file_in"
	f_rmfile "$g_file_search"
    fi
fi
if test ! -r "$g_file_in"
then
    f_msg "I301: START Creating Input: $g_file_in"
    g_files_where_created="Y"
    tr -cd '[:alnum:]' < /dev/urandom | fold -w 75 | sed 20000q \
       | sed 20000q | sed 's/^.../ok|/' | sort > "$g_file_in"
    f_msg "I302: END   Creating Input: $g_file_in"
fi
if test ! -r "$g_file_search"
then
    f_msg "I410: START Creating Input: $g_file_search"
    $PROG_SHUFFLE < $g_file_in | head -n 100 | cut -c 4-10 >  "$g_temp_01"
    $PROG_SHUFFLE < $g_file_in | head -n 100 | cut -c 4-20 >> "$g_temp_01"
    $PROG_SHUFFLE < $g_file_in | head -n 100 | cut -c 4-30 >> "$g_temp_01"
    sort < "$g_temp_01" | uniq > "$g_file_search"
    f_rmfile "$g_temp_01"
    f_msg "I412: END   Creating Input: $g_file_search"
fi
if test "$g_files_where_created" = "Y"
then
    f_msg "I420: START adding duplicates to input"
    $PROG_SHUFFLE < $g_file_search | head -n 10  > "$g_temp_01"
    $PROG_SHUFFLE < $g_file_search | head -n 3  >> "$g_temp_01"
    $PROG_SHUFFLE < $g_file_search | head -n 2  >> "$g_temp_01"
    grep -f "$g_temp_01" < $g_file_in >> $g_temp_02
    cat $g_temp_02 >> $g_file_in
    f_msg "I429: END   adding duplicates to input"
    f_rmfile $g_temp_01
    f_rmfile $g_temp_02
fi
if test ! -f "$g_file_in_delm"
then
    f_msg "I430: START Creating Delimited Input: $g_file_in_delm"
    g_cut_col_1=`awk '{ if ( length > L ) { L=length} }END{ print L}' < "$g_file_search"`
    g_cut_col_1=`expr "$g_cut_col_1" + 3`
    g_cut_col_2=`expr "$g_cut_col_1" + 1`
    awk '{printf("s/%s/%s|/\n", $1, $1)}' < "$g_file_search" > "$g_temp_01"
    cut -c 1-$g_cut_col_1 < "$g_file_in" | sed -f "$g_temp_01" \
	| sed 's/|$//' > "$g_temp_02" &
    cut -c $g_cut_col_2-1024 < "$g_file_in" > "$g_temp_03"
    wait
    paste -d \| "$g_temp_02" "$g_temp_03" > "$g_file_in_delm"
    f_rmfile "$g_temp_01"
    f_rmfile "$g_temp_02"
    f_rmfile "$g_temp_03"
    f_msg "I439: END   Creating Delimited Input: $g_file_in_delm"
fi

if test "$g_arg_search" = ""
then
    g_use_search_file="N"
    f_get_random
    g_arg_search=`head -n $g_rec_search < $g_file_search | tail -n 1 | sed 's/
$//'`
    f_msg "I440: Search Value set to: $g_arg_search"
else
    f_rmfile "$g_file_grep"
fi

if test "$g_arg_delm" != ""
then
    g_file_in_use="$g_file_in_delm"
fi

rm "$g_file_out" "$g_sort_out" "$g_file_err" \
   "$g_temp_01"  "$g_temp_02"  "$g_temp_03" > /dev/null 2>&1


#--- print version info
./jgrep -V > "$FILE_VERSION_RESULTS" 2>&1
cat << EOF >> $FILE_MAKE_RESULTS 2>&1
=====================================================================
Source  Dir: $TEST_DIR_SRC
Results Dir: $DIR_RESULTS

Program Rev:
---------------------------------------------------------------------
`cat $FILE_VERSION_RESULTS`
=====================================================================
EOF
rm $FILE_VERSION_RESULTS $FILE_VALGRIND_LOG > /dev/null 2>&1

#--- Test object
if test "$PROCESS_VALGRIND" = "Y"
then
    f_msg "A601: START ./jgrep $MSG_MEMORY" > "$FILE_VALGRIND_LOG"
    f_msg "I602: START ./jgrep $MSG_MEMORY"
    valgrind -s --tool=memcheck --leak-check=yes                   \
                --leak-check=full --show-leak-kinds=all            \
                --track-origins=yes                                \
                --keep-stacktraces=alloc-then-free                 \
                ./jgrep $g_arg_delm $g_arg_slow $g_arg_invert          \
                        -f $g_arg_verbose $g_arg_col $g_arg_quiet      \
                        -o "$g_file_out" -e "$g_file_err"              \
                        $g_arg_search "$g_file_in_use"                 \
                >> "$FILE_VALGRIND_LOG" 2>&1
    f_msg "I610: Created: $FILE_VALGRIND_LOG"
    f_msg "I611:        : $g_file_out" >> "$FILE_VALGRIND_LOG"
    f_msg "I612:        : $g_file_err" >> "$FILE_VALGRIND_LOG"
    if test "$TERM" = "dumb"
    then
	cat $FILE_VALGRIND_LOG
    fi
    f_msg "I690: END   ./jgrep $MSG_MEMORY"
    f_msg "B691: END   ./jgrep $MSG_MEMORY"  >> "$FILE_VALGRIND_LOG"
else
    f_msg "I700: START ./jgrep $MSG_MEMORY"
    $OPENBSD_KTRACE ./jgrep  $g_arg_delm $g_arg_slow $g_arg_invert \
              -f $g_arg_verbose $g_arg_col $g_arg_quiet      \
              -o $g_file_out -e $g_file_err                  \
              $g_arg_search $g_file_in_use

    g_rc="$?"
    f_msg "I710: R/C    : $g_rc"
    f_msg "I711: Created: $g_file_out"
    f_msg "I712:        : $g_file_err"
    if test "$OPENBSD_KTRACE" != ""
    then
	sleep 1
	kdump -u malloc
	sleep 1
	f_msg "I714: ***** Execute this:"
	f_msg "I715:       addr2line -e ./jgrep 0x????"
	f_msg "I716: ***** using the last hex val on the line for ./jgrep"
	f_msg "I717: ***** to see where the leak is (if any)"
    fi
    f_msg "I720: END   ./jgrep $MSG_MEMORY"
fi

#--- verify
if test "$g_arg_invert" != ""
then
    g_arg_invert="-v"
fi
if test "$g_use_search_file" = "Y"
then
    g_use_search_file="-f $g_file_search"
else
    g_use_search_file="$g_arg_search"
fi

f_msg "I730: creating validate file"
grep $g_arg_invert $g_use_search_file < "$g_file_in_use" | sort > "$g_file_grep" &
sort < $g_file_out > "$g_sort_out"
wait

f_msg "I740: comparing jdiff vs diff"
diff "$g_file_grep" "$g_sort_out" > "$g_file_diff"
if test "$?" -eq "0"
then
    f_msg "I741: SUCCESS ./jgrep vs grep(1)"
    rm  "$g_file_grep" "$g_file_diff" "$g_sort_out"
else
    f_msg "W742: FAILED  ./jgrep vs grep(1)"
    f_msg "W743: See Files:"
    f_msg "W744    $g_file_grep"
    f_msg "W745    $g_sort_out"
    f_msg "E746    $g_file_diff"
fi

exit 0
