.\"
.\" Copyright (c) 2003 ... 2025 2026
.\"     John McCue <jmccue@sdf.org>
.\"
.\" Permission to use, copy, modify, and distribute this software
.\" for any purpose with or without fee is hereby granted,
.\" provided that the above copyright notice and this permission
.\" notice appear in all copies.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
.\" WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
.\" THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
.\" CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
.\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\" SOFTWARE.
.\"
.TH JGREP 1 "2025-04-11" "JMC" "User Commands"
.SH NAME
jgrep - Text File Search
.SH SYNOPSIS
jgrep [OPTIONS] [SEARCH-TEXT] [FILE...]
.SH DESCRIPTION
Will search one or more Text Files for string SEARCH-TEXT
or from a list of SEARCH-TEXTs in a File.
.PP
If no files (FILE) are specified on the command line or
if FILE has name '-', stdin (Standard Input) is used.
.PP
You can either supply "SEARCH-TEXT" or a File
with a list of Search Texts.
.TP
-C col
Optional, start search at Character 'col' or
Field 'col' depending upon if processing Delimited (-d)
Data.
Default, search the entire Text Line.
.TP
-d delm
Optional, delimiter to use to search specific Fields
in Delimited Text File(s).
You can supply the delimiter as a specific character or a
base 10 integer that represents the character.
For example to use:
.nf
    delm   Use argument value
    -----  -----------------------------
    |      -d '|'  or -d 124
    ^G     -d 7    or BEL
    TAB    -d 9    or TAB
    SPACE  -d 32   or SPACE or -d ' '
.fi
.TP
-e file
Optional, if used, write processing messages to file 'file'.
Default, messages written to stderr.
.TP
-f
Optional, Force file create.
Create file even if the target file exists.
Default, if the file exists, abort.
.TP
-H
Optional, on each line, print the source File Name.
Default, just print the line.
.TP
-h
Show brief help and exit.
.TP
-i
Optional, treat upper/lower characters the same.
Default, search must match exactly.
.TP
-n
Optional, print line number were SEARCH-TEXT was found.
Default, just print the line.
.TP
-o file
Optional, if used, write output to file 'file'.
Default, output written to stdout.
.TP
-p file
Optional, obtain SEARCH-TEXT from file 'file',
one line per entry.
Default, SEARCH-TEXT is taken from the command line.
.TP
-q
Optional, quiet.
Do NOT print output on stdout.
Default is to print records that meets the Search Criteria on stdout.
.TP
-R
Optional, Invert (Reverse) Match.
Print Lines that do NOT Match Search Data.
Default is to print Lines that Match Search Data.
.TP
-r n
Optional, after 'n' Reads, pause for
the specified milliseconds (-s).
Default, do not pause.
See diagnostics section below.
.TP
-s m
Optional, sleep 'm' milliseconds after processing 'n' records (-r).
Default, do not pause.
.TP
-V
Output version information and exit.
.TP
-v
Optional, Verbose Level.
Print information about the run,
default do not show run messages.
Can be specified multiple times,
each specification increases verbose level:
.nf
    Level  Meaning
    -----  ---------------------------------------
    = 0    Show only Search Results and Errors
    >= 1   Show Command Line Arguments on stderr
    >= 2   Show warnings on stderr
    >= 3   Show Search Summary on stderr
    >= 4   Show Pause stats on stderr
.fi
.SH DIAGNOSTICS
Unless you need to do a search not supported by
grep(1), best to use grep(1).
.PP
Pause Reads (-p and -s) are only useful on Operating
Systems that tend to heat up when processing lots of data.
In most cases you should not need to use those options.
.PP
If you specify '-e', in some cases info will still be
written to stderr.
This can occur during Command Line Argument Processing
or in unusual memory allocation issues.
.SH SEE-ALSO
awk(1),
cut(1),
grep(1),
jr(1),
paste(1),
sed(1),
sort(1)
.SH ERROR-CODES
.nf
0 Success, data found that matches specified search criteria
1 NO data found that matches specified search criteria
2 Process Failed or Help Requested
.fi
