#!/bin/sh
#
# jfile test with valgrind or ktrace
#
# Copyright (c) 2022 ... 2025 2026
#     John McCue <jmccue@sdf.org>
#
# Permission to use, copy, modify, and distribute this software
# for any purpose with or without fee is hereby granted, provided
# that the above copyright notice and this permission notice
# appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
# WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
# LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

g_dir_bhome=`dirname $0`
cd $g_dir_bhome
g_dir_bhome=`pwd`
. $g_dir_bhome/../test/tsetup.sh

#
# main
#
g_file_in_1="$TEST_DIR_SRC/test_data/utf-8.txt"
g_file_in_2="$TEST_DIR_SRC/test_data/utf_8-demo.txt"
g_file_err=$DIR_RESULTS/val_err.txt
g_file_out=$DIR_RESULTS/val_out.txt
g_arg_mode=""

#--- validate arguments
case "$TEST_ARG" in
    "-a")
	g_arg_mode="-7 -8 -p"
	;;
    "-n")
	g_arg_mode=""
	;;
    *)
	echo ""
	g_is_error="Y"
	f_help_setup
	f_msg "W010: Required test option missing or invalid, exiting"
	exit 2
	;;
esac

#--- validate input files
if test ! -f "$g_file_in_1"
then
cat << EOF
File $g_file_in_1
can be retrieved from:
    http://kermitproject.org/utf8.html
EOF
exit 2
fi
if test ! -f "$g_file_in_2"
then
cat << EOF
File $g_file_in_2
can be retrieved from:
    https://www.cl.cam.ac.uk/~mgk25/

EOF
exit 2
fi

#--- continue on
cd $TEST_DIR_SRC
f_ckprog ./jfile

#--- print version info
./jfile -V > "$FILE_VERSION_RESULTS" 2>&1
cat << EOF >> $FILE_MAKE_RESULTS 2>&1
=====================================================================
Source  Dir: $TEST_DIR_SRC
Results Dir: $DIR_RESULTS

Program Rev:
---------------------------------------------------------------------
`cat $FILE_VERSION_RESULTS`
=====================================================================
EOF
rm $FILE_VERSION_RESULTS $FILE_VALGRIND_LOG > /dev/null 2>&1

#--- Test object
if test "$PROCESS_VALGRIND" = "Y"
then
    f_msg "A201: START ./jfile $MSG_MEMORY" > "$FILE_VALGRIND_LOG"
    f_msg "I202: START ./jfile $MSG_MEMORY"
    valgrind -s --tool=memcheck --leak-check=yes        \
                --leak-check=full --show-leak-kinds=all \
                --track-origins=yes                     \
                --keep-stacktraces=alloc-then-free      \
	        ./jfile -v -f -e $g_file_err -o $g_file_out $g_arg_mode \
		        $g_file_in_1 $g_file_in_2                       \
                >> "$FILE_VALGRIND_LOG" 2>&1
    if test "$TERM" = "dumb"
    then
	cat $FILE_VALGRIND_LOG
    fi
    f_msg "I281: Created: $FILE_VALGRIND_LOG"
    f_msg "I282:          $g_file_out"
    f_msg "I283:          $g_file_err"
    f_msg "I290: END   ./jfile $MSG_MEMORY"
    f_msg "B291: END   ./jfile $MSG_MEMORY"     >> "$FILE_VALGRIND_LOG"
else
    f_msg "I300: START ./jfile $MSG_MEMORY"
    $OPENBSD_KTRACE ./jfile -v -f -e $g_file_err -o $g_file_out $g_arg_mode \
                            $g_file_in_1 $g_file_in_2
    f_msg "I311: Created: $g_file_out"
    f_msg "I312:          $g_file_err"
    if test "$OPENBSD_KTRACE" != ""
    then
	sleep 1
	kdump -u malloc
	sleep 1
	f_msg "I323: ***** Execute this:"
	f_msg "I324:       addr2line -e ./jfile 0x????"
	f_msg "I325: ***** using the last hex val on the line for ./jfile"
	f_msg "I326: ***** to see where the leak is (if any)"
    fi
    f_msg "I330: END   ./jfile $MSG_MEMORY"
fi

exit 0
