/*
 * Copyright (c) 2013 ... 2025 2026
 *     John McCue <jmccue@sdf.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#define _FILE_OFFSET_BITS 64
#define __USE_LARGEFILE64
#define _TIME_BITS 64

#ifndef _MSDOS
#include <sys/param.h>
#endif

#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>

#ifdef HAVE_JLIB
#include <j_lib2.h>
#include <j_lib2m.h>
#endif

#include "jfile.h"

#define SIZEC  30

/*
 * init_w() -- initialize work area
 */
void init_w(struct s_work *w)

{
  init_finfo(&(w->out));
  init_finfo(&(w->err));
  w->err.fp    = stderr;
  w->out.fp    = stdout;

  w->show_utf_8          = FALSE;
  w->show_real_utf8      = FALSE;

  w->num_files           = 0;
  w->verbose             = 0;
  w->show_7bit           = FALSE;
  w->show_8bit           = FALSE;
  w->show_invalid        = FALSE;
  w->nl_not_ascii        = TRUE;
  w->flag_bom            = FALSE;
  w->force               = FALSE;

  w->delim               = JLIB2_CHAR_NULL;
  w->is_delim            = FALSE;

}  /* init_w() */

/*
 * init() -- initialize
 */
void init(int argc, char **argv, struct s_work *w)

{
  char str[(SIZEC + 1)];

  memset(str, 0, (SIZEC + 1));

  init_w(w);

  process_arg(argc, argv, w);

  if (w->verbose > 0)
    {
      fprintf(w->err.fp, MSG_INFO_I086,
              (strlen(w->err.fname) == 0 ? LIT_STDERR : w->err.fname));
      fprintf(w->err.fp, MSG_INFO_I090,
              (strlen(w->out.fname) == 0 ? LIT_STDOUT : w->out.fname));
      fprintf(w->err.fp, MSG_INFO_I081, w->num_files);
      fprintf(w->err.fp, MSG_INFO_I092, w->verbose);
      fprintf(w->err.fp, MSG_INFO_I140S, print_c(str, SIZEC, w->delim));
      fprintf(w->err.fp, MSG_INFO_I087, (w->force == TRUE ? LIT_YES : LIT_NO));
      fprintf(w->err.fp, MSG_INFO_I178,
	      (w->show_7bit == TRUE ? LIT_YES : LIT_NO));
      fprintf(w->err.fp, MSG_INFO_I179,
	      (w->show_8bit == TRUE ? LIT_YES : LIT_NO));
      fprintf(w->err.fp, MSG_INFO_I180,
	      (w->show_invalid == TRUE ? LIT_YES : LIT_NO));
      fprintf(w->err.fp, MSG_INFO_I181,
	      (w->show_utf_8 == TRUE ? LIT_YES : LIT_NO));
      fprintf(w->err.fp, MSG_INFO_I182,
	      (w->show_real_utf8 == TRUE ? LIT_YES : LIT_NO));
      fprintf(w->err.fp, MSG_INFO_I183,
	      (w->flag_bom == TRUE ? LIT_YES : LIT_NO));
      fprintf(w->err.fp, MSG_INFO_I184,
	      (w->nl_not_ascii == FALSE ? LIT_NO : LIT_YES));
    }

}  /* init() */

/*
 * init_count() -- initialize count area
 */
void init_count(struct s_counts *c)

{
  c->bom_found                 = (int) FALSE;
  c->lines_read                = 0L;
  c->bytes_read                = 0L;
  c->count_utf8                = 0L;
  c->count_utf8_extra          = 0L;
  c->count_utf8_overlong       = 0L;
  c->count_utf8_overlong_extra = 0L;
  c->count_utf8_invalid        = 0L;
  c->count_utf8_invalid_extra  = 0L;
  c->count_utf8_unalloc        = 0L;
  c->count_utf8_unalloc_extra  = 0L;
  c->count_7bit                = 0L;
  c->count_8bit                = 0L;
  c->count_ctrl                = 0L;
  c->bytes_undefined           = 0L;

} /* init_count() */

/*
 * print_c() - format the character or its hex value for printing
 */
char *print_c(char *str, int sizc, unsigned char c)
{

  switch (c)
    {
      case 0:
	snprintf(str, sizc, "%s", "none");
	return(str);
      case 7:
	snprintf(str, sizc, "%s", "BEL");
	return(str);
      case 9:
	snprintf(str, sizc, "%s", "TAB");
	return(str);
      case 32:
	snprintf(str, sizc, "%s", "space");
	return(str);
    }

  if ((c < 33) || (c > 126))
    {
      snprintf(str, sizc, "0x%02X", c);
      return(str);
    }

  snprintf(str, sizc, "%c", c);
  return(str);

} /* print_c() */
