.\"
.\" Copyright (c) 2014 ... 2025 2026
.\"     John McCue <jmccue@sdf.org>
.\"
.\" Permission to use, copy, modify, and distribute this software
.\" for any purpose with or without fee is hereby granted,
.\" provided that the above copyright notice and this permission
.\" notice appear in all copies.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
.\" WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
.\" THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
.\" CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
.\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\" SOFTWARE.
.\"
.TH JFILE 1 "2013-07-14" "JMC" "User Commands"
.SH NAME
jfile - Display Characters Statistics of a Text File
.SH SYNOPSIS
jfile [OPTIONS] [FILE...]
.SH DESCRIPTION
Print character statistics about 1 or more
text files.
This can be useful to see if a Text File
that is assumed to be UTF-8 contains undefined
characters.
.PP
If no files (FILE) are specified on the command line or
if FILE has name '-', stdin (Standard Input) is used.
.TP
-7
Optional, display details about 7-bit ASCII characters found.
.TP
-8
Optional, display details about 8-bit ASCII (extended) characters found.
.TP
-B
Optional, flag the UTF-8 BOM (Byte Order Mark).
Default is to ignore the BOM.
Usually, only files created on Microsoft systems
will have a BOM.
Use of a UTF-8 BOM is not recommended in text files,
but this option allows you to ignore it when validating a text file.
.TP
-d c
Optional, character 'c' is the field delimiter.
If specified the character will be counted as a 7-bit ASCII character.
It must have a decimal value less than 128 (ie: < 0x80).
.TP
-e file
Optional, if used, write error messages to file 'file'.
If not specified, errors written to stderr.
.TP
-f
Optional, Force file create.
Create file even if the target file exists.
.TP
-h
Show brief help and exit.
.TP
-I
Optional, display details about ctrl (Control/Invalid) characters found.
.TP
-n
Optional, do NOT treat new-line characters as 7-bit ASCII.
Default is to assume new line (^J, 0x0a) is valid.
The default will also treat return characters (^M, 0x0d) as valid
if they are followed by a new-line.
.TP
-o file
Optional, if used, write output to file 'file'.
If not specified, output written to stdout.
.TP
-p
Optional, print the UTF-8 character on the detail report
instead of asterisks (*).
The default is to print one asterisks per byte
on the report.
Depending upon what is used to view the report,
columns may not line up up.
.TP
-U
Optional, display details about UTF-8 characters found.
.TP
-V
Output version information and exit.
.TP
-v
Optional, Verbose Level.
Print information about the run.
Can be specified multiple times,
each specification increases verbose level:
.nf
    Level  Meaning
    -----  ------------------------------------------------
    = 0    Show just Character Summary on stdout.
           Show only errors on stderr.
    >= 1   Show non-7bit ASCII character details on stdout.
           This is the same as using arguments -8 -I -U.
           Show arguments and other info on stderr.
.fi
.SH DIAGNOSTICS
Note, if an error occurs while parsing command line arguments,
errors may be written stderr instead of the error file specified.
.PP
If desired, a detail report can be generated for
each character examined.
The report is formatted as:
.nf

    Byte Record Pos Char Hex              Type (ASCII/UTF-8 ...)
    ---- ------ --- ---- ---------------- -----------------------

    Byte      = character position in the file
    Record    = Record Number where the character is found, assumes
                each record is separated by a new-line (0x0a)
    Pos       = Position in the Record of the character
    Char      = Character.  If it is a UTF-8 character, a string of
                '*' will be shown were each '*' represents one byte
		(see '-p' above)
    Hex       = Hexadecimal representation of the character
    Type ...  = Describes the Type of the character
.fi
.PP
This table shows how it determines a UTF-8 characters.
.nf
    .--------+---------------------------------------------------.
    | Type   | Byte 1     | Byte 2     | Byte 3     | Byte 4     |
    |--------+------------+------------+------------+------------|
    | 1 Byte | 0xxx xxxx  |            |            |            |
    |    dec |   0 to 127 |            |            |            |
    |    hex |  00 to 7F  |            |            |            |
    |--------+------------+------------+------------+------------|
    | 2 Byte | 110x xxxx  | 10xx xxxx  |            |            |
    |    dec | 192 to 223 | 128 to 191 |            |            |
    |    hex |  C0 to DF  |  80 to BF  |            |            |
    |--------+------------+------------+------------+------------|
    | 3 Byte | 1110 xxxx  | 10xx xxxx  | 10xx xxxx  |            |
    |    dec | 224 to 239 | 128 to 191 | 128 to 191 |            |
    |    hex |  E0 to EF  |  80 to BF  |  80 to BF  |            |
    |--------+------------+------------+------------+------------|
    | 4 Byte | 1111 0xxx  | 10xx xxxx  | 10xx xxxx  | 10xx xxxx  |
    |    dec | 240 to 247 | 128 to 191 | 128 to 191 | 128 to 191 |
    |    hex |  F0 to F7  |  80 to BF  |  80 to BF  |  80 to BF  |
    '------------------------------------------------------------'
.fi
It is from from:
.nf
    https://en.wikipedia.org/wiki/UTF-8
.fi
.PP
Overlong and Invalid UTF-8 encodings are flagged as Invalid.
If some overlongs are erroneously flagged (doubtful) as valid,
this utility will still be able to flag problematic characters.
.PP
Arguments -v, -7, -8 and -U can generate a large output file.
This is because each line shows details about the character found.
.SH BUGS
Probably, but this will be able to determine
if a Text File contains unexpected encodings.
.SH SEE-ALSO
ascii(7),
file(1),
hexdump(1),
iconv(1),
jascii(1),
jhd(1),
magic(5),
od(1),
strings(1)
 ERROR-CODES
.nf
0 success
1 processing error or help/rev displayed
.fi
