#!/bin/sh
#
# jexpand - test with valgrind or ktrace
#
# Copyright (c) 2022 ... 2025 2026
#     John McCue <jmccue@sdf.org>
#
# Permission to use, copy, modify, and distribute this software
# for any purpose with or without fee is hereby granted, provided
# that the above copyright notice and this permission notice
# appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
# WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
# LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

g_dir_bhome=`dirname $0`
cd $g_dir_bhome
g_dir_bhome=`pwd`
. $g_dir_bhome/../test/tsetup.sh

#
# main
#
g_file_original=$TEST_DIR_SRC/jexpand.c
g_file_err=$DIR_RESULTS/val_err.txt
g_file_out=$DIR_RESULTS/val_out.txt
g_file_in=$DIR_RESULTS/val_in.txt
g_file_temp_f1=$DIR_RESULTS/val_temp_f1.txt
g_file_temp_f2=$DIR_RESULTS/val_temp_f2.txt

cd $TEST_DIR_SRC
f_ckprog unexpand
f_ckprog ./jexpand
f_ckfile -r "$g_file_original"

#--- create input files
f_msg "I010: creating $g_file_in"

sed 's/ *$//g' < "$g_file_original"            \
    | sed 's/$/                            X/' \
    | unexpand -a > "$g_file_in"

#--- print version info
./jexpand -V > "$FILE_VERSION_RESULTS" 2>&1
cat << EOF >> $FILE_MAKE_RESULTS 2>&1
=====================================================================
Source  Dir: $TEST_DIR_SRC
Results Dir: $DIR_RESULTS

Program Rev:
---------------------------------------------------------------------
`cat $FILE_VERSION_RESULTS`
=====================================================================
EOF
rm $FILE_VERSION_RESULTS $FILE_VALGRIND_LOG > /dev/null 2>&1
rm "$g_file_temp_f1" "$g_file_temp_f2" "$g_file_out" > /dev/null 2>&1

#--- Test object
if test "$PROCESS_VALGRIND" = "Y"
then
    f_msg "A201: START ./jexpand $MSG_MEMORY" > "$FILE_VALGRIND_LOG"
    f_msg "I202: START ./jexpand $MSG_MEMORY"
    valgrind -s --tool=memcheck --leak-check=yes        \
                --leak-check=full --show-leak-kinds=all \
                --track-origins=yes                     \
                --keep-stacktraces=alloc-then-free      \
	        ./jexpand -vv -f -e $g_file_err -o $g_file_out $g_file_in  \
                >> "$FILE_VALGRIND_LOG" 2>&1
    if test "$TERM" = "dumb"
    then
	cat $FILE_VALGRIND_LOG
    fi
    f_msg "I281: Created: $FILE_VALGRIND_LOG"
    f_msg "I282:          $g_file_out"
    f_msg "I283:          $g_file_err"
    f_msg "I290: END   ./jexpand $MSG_MEMORY"
    f_msg "B291: END   ./jexpand $MSG_MEMORY" >> "$FILE_VALGRIND_LOG"
else
    f_msg "I300: START ./jexpand $MSG_MEMORY"
    $OPENBSD_KTRACE ./jexpand -vv -f -e $g_file_err -o $g_file_out $g_file_in
    if test "$OPENBSD_KTRACE" != ""
    then
	sleep 1
	kdump -u malloc
	sleep 1
	f_msg "I313: ***** Execute this:"
	f_msg "I314:       addr2line -e ./jexpand 0x????"
	f_msg "I315: ***** using the last hex val on the line for ./jexpand"
	f_msg "I316: ***** to see where the leak is (if any)"
    fi
    f_msg "I321: Created: $g_file_out"
    f_msg "I322:          $g_file_err"
    f_msg "I330: END   ./jexpand $MSG_MEMORY"
fi

#--- check results
diff -w "$g_file_in" "$g_file_out" > /dev/null 2>&1
if test "$?" -eq "0"
then
    sed 's/ X$//' < "$g_file_original" | sed 's/ *$//g' | unexpand > "$g_file_temp_f1"
    sed 's/ X$//' < "$g_file_out"      | sed 's/ *$//g' | unexpand > "$g_file_temp_f2"
    diff "$g_file_temp_f1" "$g_file_temp_f2" > /dev/null 2>&1
    if test "$?" -eq "0"
    then
	f_msg "I401: SUCCESS ./jexpand vs expand(1)"
	rm "$g_file_temp_f1" "$g_file_temp_f2" > /dev/null 2>&1
    else
	f_msg "W411: FAILED  ./jexpand vs expand(1) uing:"
	f_msg "W412:     $g_file_temp_f1"
	f_msg "W413:     $g_file_temp_f2"
    fi
else
    f_msg "W421: FAILED  ./jexpand vs expand(1) uing:"
    f_msg "W422:     $g_file_in"
    f_msg "W423:     $g_file_out"
fi

exit 0
