.\"
.\" Copyright (c) 2005 ... 2025 2026
.\"     John McCue <jmccue@sdf.org>
.\"
.\" Permission to use, copy, modify, and distribute this software
.\" for any purpose with or without fee is hereby granted,
.\" provided that the above copyright notice and this permission
.\" notice appear in all copies.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
.\" WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
.\" THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
.\" CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
.\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\" SOFTWARE.
.\"
.TH JEXPAND 1 "2005-06-29" "JMC" "User Commands"
.SH NAME
jexpand - Expand tabs to spaces
.SH SYNOPSIS
jexpand [OPTIONS] [FILE...]
.SH DESCRIPTION
Reads 1 or more files, expand tabs to spaces and
writes output to stdout.
.PP
If no files (FILE) are specified on the command line or
if FILE has name "-", stdin (Standard Input) is used.
.TP
-e file
Write errors/stats to file 'file'.
Default is to to use stderr.
.TP
-f
Force file create.
Create out file even if the target file exists.
.TP
-h
Show brief help and exit.
.TP
-o file
Write Output to file 'file'.
Default is to to use stdout.
.TP
-t #
Tab Stop, determines how many spaces to use when replacing
the TAB character.
If not specified, defaults to 8
.TP
-V
output version information and exit.
.TP
-v
Optional, Verbose Level.
Print information about the run,
default do not show run messages.
Can be specified multiple times,
each specification increases verbose level:
.nf
    Level  Meaning
    -----  -------------------------------------
    = 0    Do not show any messages, default
    >= 1   Show summary and warnings on stderr
    >= 2   Show arguments on stderr
    >= 3   Show headings on stdout as each file
           is processed
.fi
.SH DIAGNOSTICS
Note, if an error occurs while parsing command line arguments,
errors may be written stderr instead of the error file specified.
.SH SEE-ALSO
expand(1),
unexpand(1)
.SH ERROR-CODES
.nf
0 success
1 processing error or help/rev displayed
.fi
