/*
 * Copyright (c) 2005 ... 2025 2026
 *     John McCue <jmccue@sdf.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
#ifndef JEXPAND_H

#define JEXPAND_H "3.10 2025/07/30"
#define PROG_NAME "jexpand"

#define EXPAND_TAB_DEFAULT 8
#define PATH_IS_VALID      0
#define PATH_IS_NULL       1
#define PATH_IS_EMPTY      2
#define PATH_IS_BIG        3
#define PATH_HAS_SPACE     4
#define PATH_INVALID       5

#ifndef JLIB2_CHAR_NULL
#define NO_JLIB 1
#define JLIB2_CHAR_NULL  ((char) '\0')
#endif

#ifndef NULL
#define NULL '\0'
#endif
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#ifndef SSIZE_T
#define SSIZE_T ssize_t
#endif
#ifndef TAB_CHAR
#define TAB_CHAR 0x09
#endif

#ifdef MAXPATHLEN
#ifndef PATH_MAX
#define PATH_MAX MAXPATHLEN
#endif
#else
#ifdef PATH_MAX
#define MAXPATHLEN PATH_MAX
#endif
#endif

#ifndef SSIZE_T
#ifdef _MSDOS
#define SSIZE_T unsigned long int
#endif
#else
#define SSIZE_T ssize_t
#endif

struct s_file_info
{
  FILE *fp;
  char fname[(PATH_MAX + 1)];
  int  ok_to_close;  /* TRUE or FALSE */
  SSIZE_T reads;
  SSIZE_T writes;
  SSIZE_T bytes;
} ;

struct s_work
{
  int  force;               /* TRUE or FALSE, defaults to FALSE */
  int  verbose;             /* TRUE or FALSE, defaults to FALSE */
  int  tab_size;            /* TAB stop location, default 8     */
  int  num_files;           /* Number of input files */
  struct s_file_info out;
  struct s_file_info err;
} ;

#ifdef NO_JLIB
#define ARG_ERR           'e'  /* Output Error File                  */
#define ARG_FORCE         'f'  /* force create files                 */
#define ARG_HELP          'h'  /* Show Help                          */
#define ARG_OUT           'o'  /* Output File                        */
#define ARG_TAB_SPACE     'T'  /* Expand tabs to # characters        */
#define ARG_VERBOSE       'v'  /* Verbose                            */
#define ARG_VERSION       'V'  /* Show Version Information           */
#define FILE_NAME_STD     "-"
#define SWITCH_CHAR       '-'

#define LIT_BYTES         "Bytes"
#define LIT_C80           "::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::"
#define LIT_FILE          "File"
#define LIT_INFO_04       "Build: %s %s\n"
#define LIT_INFO_END      "******* End of Report *******"
#define LIT_LINES_READ    "Lines Read"
#define LIT_LINES_WRITES  "Lines Written"
#define LIT_NO            "No"
#define LIT_NULL          "<null>"
#define LIT_REV           "Revision"
#define LIT_STDERR        "(standard error)"
#define LIT_STDIN         "(standard input)"
#define LIT_STDOUT        "(standard output)"
#define LIT_ULINE_10      "----------"
#define LIT_ULINE_13      "-------------"
#define LIT_ULINE_44      "-------------------------------------------"
#define LIT_YES           "Yes"

#define MSG_ERR_E000      "Try '%s %c%c' for more information\n"
#define MSG_ERR_E002      "ERROR E002: Cannot open '%s' for write, processing aborted\n"
#define MSG_ERR_E004S     "ERROR E004: value '%s' invalid value for %c%c\n"
#define MSG_ERR_E004SB    "ERROR E004: value '%s' value for %c%c too large\n"
#define MSG_ERR_E006      "ERROR E006: '%s' is an invalid value for %c%c\n"
#define MSG_ERR_E023      "ERROR E023: Cannot allocate memory when processing file %s, file bypassed\n"
#define MSG_ERR_E025      "ERROR E025: File %s cannot be created, already exists\n"
#define MSG_ERR_E074      "ERROR E074: 'Too many Arguments specified for %c%c\n"
#define MSG_ERR_E112      "ERROR E112: cannot open %s, already opened\n"
#define MSG_ERR_E113      "ERROR E113: stdin can only be used once\n"
#define MSG_ERR_E116      "ERROR E116: Cannot allocate memory for Record %lld, file: %s\n"
#define MSG_INFO_I043L    "I043: Input  File                  : %s\n"
#define MSG_INFO_I081     "I081: Number of Input Files          %d\n"
#define MSG_INFO_I086     "I086: Errors written to File       : %s\n"
#define MSG_INFO_I087     "I087: Force Create Output          ? %s\n"
#define MSG_INFO_I090     "I090: Output written to File       : %s\n"
#define MSG_INFO_I092     "I092: Verbose Level                  %d\n"
#define MSG_INFO_I152L    "I152:       Run Time:  %lld second(s)\n"
#define MSG_INFO_I167     "I167: Expand each Tab to %d spaces\n"
#define MSG_WARN_W002     "W002: Open Error Bypass File '%s' : %s\n"

#define USG_MSG_ARG_ERR           "\t%c%c file\t\t: Write errors to file 'file', default stderr\n"
#define USG_MSG_ARG_FORCE         "\t%c%c\t\t: force create of files when found\n"
#define USG_MSG_ARG_HELP          "\t%c%c\t\t: Show brief help and exit\n"
#define USG_MSG_ARG_OUT           "\t%c%c file\t\t: Write output to file 'file', default stdout\n"
#define USG_MSG_ARG_TAB_SPACE_A   "\t%c%c num\t\t: Expand tabs to 'num' spaces.\n"
#define USG_MSG_ARG_VERBOSE_5     "\t%c%c\t\t: show run stats on stderr\n"
#define USG_MSG_ARG_VERSION       "\t%c%c\t\t: Show revision information and exit\n"
#define USG_MSG_OPTIONS           "Options\n"
#define USG_MSG_USAGE             "usage:\t%s [OPTIONS] [FILES ...]\n"
#endif /* NO_JLIB */

/*** prototypes ***/
void process_arg(int, char **, struct s_work *);
void init(struct s_work *, char **, int);
void init_finfo(struct s_file_info *);
void show_rev();
void show_brief_help();
int  open_in(struct s_file_info *, struct s_file_info *, char *);
void open_out(struct s_file_info *, char *, int);
void close_file(struct s_file_info *);
void check_path_file(FILE *, char *, char);

#ifdef NO_JLIB
SSIZE_T j2_getline(char **, size_t *, FILE *);
int j2_expand_tab(int, size_t *, char **, char *);
int j2_f_exist(char *);
long int j2_bye_last(char *, char);
long int j2_clr_str(char *, char, int);
#define j2_bye_nl(x)    j2_bye_last((x), '\n')
#define j2_bye_ctlm(x)  j2_bye_last((x), '\r')
#endif /* NO_JLIB */

#endif /* JEXPAND_H */
