#!/bin/sh
#
# Test script for jdiff
#
# Copyright (c) 2022 ... 2025 2026
#     John McCue <jmccue@sdf.org>
#
# Permission to use, copy, modify, and distribute this software
# for any purpose with or without fee is hereby granted, provided
# that the above copyright notice and this permission notice
# appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
# WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
# LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

g_dir_bhome=`dirname $0`
cd $g_dir_bhome
g_dir_bhome=`pwd`
. $g_dir_bhome/../test/tsetup.sh

f_rmf()
{
    rm "$g_file_temp_f1" "$g_file_sequence" "$g_out_diff"     \
       "$g_out_diff_cnv" "$g_out_jdiff_cnv" "$g_file_temp_f1" \
       > /dev/null 2>&1

} # END: f_rmf()

f_trap()
{
    j_msg "W900: CTL-C pressed, exit"
    f_rmf
    rm "$g_file_sequence" "$g_file_input_f1" \
       "$g_file_input_f2" > /dev/null 2>&1
    exit 2
} # END: f_trap()

f_gen_file()
{
    l_gf_ofile="$1"
    l_gf_start="0"
    l_gf_end="0"
    l_gf_tail="0"

    l_gf_start=`tr -cd '[:digit:]' < /dev/urandom | fold -w 4 | sed 1q`
    l_gf_end=`expr "$l_gf_start" + 1000`
    l_gf_tail=`tr -cd '[:digit:]' < /dev/urandom | fold -w 2 | sed 1q`

    head -n 100           < "$g_file_sequence" > "$g_file_temp_f1"
    head -n "$l_gf_start" < "$g_file_sequence" | tail -n 10 >> "$g_file_temp_f1"
    tail -n "$l_gf_tail"  < "$g_file_sequence" >> "$g_file_temp_f1"

    #--- add dups
    l_gf_start=`tr -cd '[:digit:]' < /dev/urandom | fold -w 2 | sed 1q`
    head -n "$l_gf_start" < "$g_file_sequence" >> "$g_file_temp_f1"
    l_gf_start=`tr -cd '[:digit:]' < /dev/urandom | fold -w 2 | sed 1q`
    head -n "$l_gf_start" < "$g_file_sequence" >> "$g_file_temp_f1"

    sort < "$g_file_temp_f1" > "$l_gf_ofile"
    rm "$g_file_temp_f1"

} # END: f_gen_file()

#
# main
#

g_file_sequence="$DIR_RESULTS/val_sequence.txt"
g_file_input_f1="$DIR_RESULTS/val_in_1.txt"
g_file_input_f2="$DIR_RESULTS/val_in_2.txt"

g_out_err="$DIR_RESULTS/val_err.txt"
g_out_jdiff="$DIR_RESULTS/out_jdiff.txt"
g_out_diff="$DIR_RESULTS/out_diff.txt"
g_out_diff_cnv="$DIR_RESULTS/out_diff_convert.txt"
g_out_jdiff_cnv="$DIR_RESULTS/out_jdiff_convert.txt"

g_file_temp_f1="$DIR_RESULTS/tmp.jdiff.gen"

cd $TEST_DIR_SRC
f_ckprog ./jdiff
f_ckprog seq
f_ckprog tr

trap f_trap INT TERM

#--- create input files
if test ! -f "$g_file_input_f1"
then
    f_msg "I100 Creating Input Files"
    seq -w 1 10000 > "$g_file_sequence"
    f_gen_file "$g_file_input_f1"
    f_gen_file "$g_file_input_f2"
fi
f_ckfile "r" "$g_file_input_f1"
f_ckfile "r" "$g_file_input_f2"

#--- print version info
./jdiff -V > "$FILE_VERSION_RESULTS" 2>&1
cat << EOF >> $FILE_MAKE_RESULTS 2>&1
=====================================================================
Source  Dir: $TEST_DIR_SRC
Results Dir: $DIR_RESULTS

Program Rev:
---------------------------------------------------------------------
`cat $FILE_VERSION_RESULTS`
=====================================================================
EOF
rm "$FILE_VERSION_RESULTS"  "$FILE_VALGRIND_LOG"  > /dev/null 2>&1
if test "$g_out_err" != "-"
then
   rm "$g_out_err"  > /dev/null 2>&1
fi
if test "$g_out_err" != "-"
then
   rm "$g_out_jdiff" > /dev/null 2>&1
fi

#--- Test object
if test "$PROCESS_VALGRIND" = "Y"
then
    f_msg "A100: START ./jdiff $MSG_MEMORY" > "$FILE_VALGRIND_LOG"
    f_msg "I101: START ./jdiff $MSG_MEMORY"
    valgrind -s --tool=memcheck --leak-check=yes        \
                --leak-check=full --show-leak-kinds=all \
                --track-origins=yes                     \
                --keep-stacktraces=alloc-then-free      \
		    ./jdiff -m 0 -b 8 -vvvv -f                    \
                            -e $g_out_err                        \
                            -o $g_out_jdiff                        \
                            "$g_file_input_f1" "$g_file_input_f2" \
                >> "$FILE_VALGRIND_LOG" 2>&1
    f_msg "I120: END   ./jdiff $MSG_MEMORY"
    f_msg "B121: END   ./jdiff $MSG_MEMORY" >> "$FILE_VALGRIND_LOG"
else
    f_msg "I300: START ./jdiff $MSG_MEMORY"
    $OPENBSD_KTRACE ./jdiff -m 0 -b 8 -vvvv             \
                            -e $g_out_err              \
                            -o $g_out_jdiff              \
                            "$g_file_input_f1" "$g_file_input_f2"
    if test "$OPENBSD_KTRACE" != ""
    then
	sleep 1
	kdump -u malloc
	sleep 1
	f_msg "I313: ***** Execute this:"
	f_msg "I314:       addr2line -e ./jdiff 0x????"
	f_msg "I315: ***** using the last hex val on the line for ./jdiff"
	f_msg "I316: ***** to see where the leak is (if any)"
    fi
    f_msg "I320: END   ./jdiff $MSG_MEMORY"
fi

#--- check results
if test ! -f "$g_out_jdiff"
then
    if test -f "$g_out_err"
    then
	grep "I214: Write Differances Found    ? No" < "$g_out_err" > /dev/null 2>&1
	if test "$?" -eq "0"
	then
	    f_msg "W400: Cannot validate, -q supplied to jdiff"
	    exit 0
	fi
    fi
    f_msg "I401: Cannot validate, file:"
    f_msg "I402:     $g_out_jdiff"
    f_msg "I403: missing.  Was argument -q used ?"
    exit 0
fi

diff "$g_file_input_f1" "$g_file_input_f2" > "$g_out_diff"

egrep '<|>' < "$g_out_diff"  | sed 's/< //;s/> //' | sort > "$g_out_diff_cnv" &
awk -F ':' '{print $4}' < "$g_out_jdiff" | sed 's/^ *//g' | sort > "$g_out_jdiff_cnv"
wait

diff "$g_out_diff_cnv" "$g_out_jdiff_cnv" > /dev/null 2>&1
if test "$?" -eq "0"
then
    f_msg "I500: SUCCESS ./jdiff vs diff"
else
    f_msg "W502: FAILED  ./jdiff vs diff(1)"
    f_msg "W503: See Files:"
    f_msg "W504    $g_out_diff_cnv"
    f_msg "E505    $g_out_jdiff_cnv"
fi

#--- DONE
f_rmf
exit 0
