.\"
.\" Copyright (c) 2004 ... 2025 2026
.\"     John McCue <jmccue@sdf.org>
.\"
.\" Permission to use, copy, modify, and distribute this software
.\" for any purpose with or without fee is hereby granted,
.\" provided that the above copyright notice and this permission
.\" notice appear in all copies.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
.\" WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
.\" THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
.\" CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
.\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\" SOFTWARE.
.\"
.TH JDIFF 1 "2004-04-11" "JMC" "User Commands"
.SH NAME
jdiff - diff a Large Sorted Text Files
.SH SYNOPSIS
jdiff [OPTIONS] file1 file2
.SH DESCRIPTION
This utility will perform a diff on Sorted
Text Files.
This can use far less system resources than diff(1)
when comparing Extremely Large Files.
.PP
If only one File is specified or one of the File Names is '-',
stdin will be used for that File.
.TP
-b n
Optional, set Read Buffer to size 'n'.
Default, use a Read Buffer Size of 256 Bytes.
.TP
-e file
Optional, if used, write error messages to file 'file'.
If not specified, errors written to stderr.
.TP
-h
Show brief help and exit.
.TP
-m n
Optional, Print no more than 'n' differences.
Default, print a maximum of 2000 lines of differences.
Set to zero to print all differences.
Note, see argument '-q' below.
.TP
-o file
Optional, if used, write output to file 'file'.
If not specified, output written to stdout.
.TP
-q
Do not print any output, only output printed will
be errors.
This will override the settings of Arguments '-m' and '-v'.
Default, show data based upon defaults or arguments
specified.
.TP
-V
Output version information and exit.
.TP
-v
Optional, Verbose Level.
Print information on stderr about the run,
default do not show run messages.
Can be specified multiple times,
each specification increases verbose level (Note, see '-q' above):
.nf
    Level  Meaning
    -----  --------------------------------------------
    = 0    Show only errors
    >= 1   Show Warnings
    >= 2   Show Processing Stats
    >= 3   Show Command Line Arguments
    >= 4   print statuses during execution
.fi
.SH DIAGNOSTICS
You should try diff(1) first, but on some
systems, diff(1) will abort due to memory constraints.
.PP
If you specify '-e', in some cases info will still be
written to stderr.
This can occur during Command Line Argument Processing
or in unusual memory allocation issues.
.PP
Uses a fixed length read buffer, this is done to avoid
many memory allocation calls.
This can be modified via argument '-b'.
.PP
Since the purpose of this Utility
is to diff very large sorted files extracted
from various databases,
differences printed will be limited.
This behavior can be changed by Arguments '-m' and '-q'.
.PP
Does not print output in standard diff(1) format.
Outputs File Number (F1/F2), Record Number, Item that differs.
.PP
For each Record, will only compare the first buffer size
characters.
All other characters on the line are ignored.
See (-b) above.
.SH SEE-ALSO
cmp(1),
diff(1)
.SH ERROR-CODES
.nf
0 success, no differences
1 Differences Found
2 Runtime error occurred
.fi
