#!/bin/sh
#
# jcsv - Test for jcsv
#
# Copyright (c) 2022 ... 2025 2026
#     John McCue <jmccue@sdf.org>
#
# Permission to use, copy, modify, and distribute this software
# for any purpose with or without fee is hereby granted, provided
# that the above copyright notice and this permission notice
# appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
# WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
# LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

g_dir_bhome=`dirname $0`
cd $g_dir_bhome
g_dir_bhome=`pwd`
. $g_dir_bhome/../test/tsetup.sh

f_create_files()
{

cat << EOF > "$g_file_in_text"
1|Name|3|Adr|col|6|.007|-800-|0.009|
-1|2|3|4|5|6|7|8|9|10|11|12|-13|14-|.15-|-.16|0.17-
1|2|3|4|5|6|7|8|9|10|11|12|13|14|||17||19||21
ABBOT-DAVAN, FRED|npwmd|12/13/2012||||||XX
Maureen|sdnr|02/27/2013||||||XX|13:45:56|12-07-59|
Smith|John|02/27/2013|10291|20 Main St, Dracut|1,209,309.19-
McCoy|Lenord|2014/02/27|12:03:40|10291|20 Main St, Centreville|10,309.11
Kirk|James|2014/02/27|12:03:40|10291|20 Main St, Centreville for a"large column|10,309.12
EOF

cat << EOF > "$g_file_in_csv"
1,2
"1",2,"3",4,5,6,"7","8","9",10,11,"12","13",14
1,2,"3",4,5,6,"7","8","9",10,11,"12","13",14,,,17,,"19",,21
"ABBOT-DAVAN, FRED",npwmd,12/13/2012,"","","","","",XX
"Maureen","sdnr",02/27/2013,"","","","","","XX",13:45:56,12-07-59
"Smith","John",02/27/2013,10291,"23 Main St, Centreville","1,209,309.19-"
"McCoy","Lenord",2014/02/27,12:03:40,10291,"42 Main St, Centreville",10,309.12
"Kirk","James",2014/02/27,12:03:40,10291,"20 Main St, Centreville for a"large column",10,309.12
EOF

} # END: f_create_files()

#
# main
#

g_file_in_airport="$HOME/Data/weather/airports.csv"
g_file_in_text="$DIR_RESULTS/val_in.txt"
g_file_in_csv="$DIR_RESULTS/val_in.csv"
g_file_out="$DIR_RESULTS/val_out.txt"
g_file_err="$DIR_RESULTS/val_err.txt"
g_file_in_use=""

if test "$TEST_ARG" = ""
then
    g_rmode="default"
else
    g_rmode="$TEST_ARG"
fi

cd $TEST_DIR_SRC
f_ckprog jwc
f_ckprog ./jcsv

#--- Create files
if test ! -f "$g_file_in_text"
then
    f_msg "I100: jcsv - Creating Input Files"
    f_create_files
fi

#--- print version info
./jcsv -V > "$FILE_VERSION_RESULTS" 2>&1
cat << EOF >> $FILE_MAKE_RESULTS 2>&1
=====================================================================
Source  Dir: $TEST_DIR_SRC
Results Dir: $DIR_RESULTS

Program Rev:
---------------------------------------------------------------------
`cat $FILE_VERSION_RESULTS`
=====================================================================
EOF
rm $FILE_VERSION_RESULTS $FILE_VALGRIND_LOG > /dev/null 2>&1
rm "$g_file_out" "$g_file_err" > /dev/null 2>&1
rm "$DIR_RESULTS/val_out.csv" "$DIR_RESULTS/val_out.txt" > /dev/null 2>&1

#--- Test object
if test "$PROCESS_VALGRIND" = "Y"
then
    f_msg "I200: START jcsv - Test Option $g_rmode $MSG_MEMORY"
    case "$g_rmode" in
	"t")
	    g_file_in_use="$g_file_in_text"
	    g_file_out="$DIR_RESULTS/val_out.csv"
	    f_msg "A210: test t $MSG_MEMORY"
	    valgrind -s --tool=memcheck --leak-check=yes        \
			--leak-check=full --show-leak-kinds=all \
			--track-origins=yes                     \
			./jcsv -f -d 124 -cv -o "$g_file_out"   \
	                       -e "$g_file_err" $g_file_in_text \
			>> "$FILE_VALGRIND_LOG" 2>&1
	    f_msg "B211: test t $MSG_MEMORY"
	    ;;
	"t0")
	    g_file_in_use="$g_file_in_text"
	    g_file_out="$DIR_RESULTS/val_out.csv"
	    f_msg "A212: test t0 $MSG_MEMORY"
	    valgrind -s --tool=memcheck --leak-check=yes           \
			--leak-check=full --show-leak-kinds=all    \
			--track-origins=yes                        \
			./jcsv -f -vvv -t 0 -d 124 -cv             \
	                       -o "$g_file_out" -e "$g_file_err"   \
	                       $g_file_in_text                     \
			>> "$FILE_VALGRIND_LOG" 2>&1
	    f_msg "B213: test t0 $MSG_MEMORY"
	    ;;
	"t1")
	    g_file_in_use="$g_file_in_csv"
	    f_msg "A221: test t1 $MSG_MEMORY"
	    valgrind -s --tool=memcheck --leak-check=yes        \
			--leak-check=full --show-leak-kinds=all \
			--track-origins=yes                     \
			./jcsv -f -d 124 -vvv -o "$g_file_out"  \
	                       -e "$g_file_err" $g_file_in_csv  \
			>> "$FILE_VALGRIND_LOG" 2>&1
	    f_msg "B222: test t1 $MSG_MEMORY"
	    ;;
	"t2")
	    g_file_in_use="$g_file_in_text"
	    g_file_out="$DIR_RESULTS/val_out.csv"
	    f_msg "A213: test t2 $MSG_MEMORY" >> "$FILE_VALGRIND_LOG" 2>&1
	    valgrind -s --tool=memcheck --leak-check=yes        \
			--leak-check=full --show-leak-kinds=all \
			--track-origins=yes                     \
			./jcsv -f -d 124 -cvvv -o "$g_file_out" \
	                       -e "$g_file_err" $g_file_in_text \
			>> "$FILE_VALGRIND_LOG" 2>&1
	    f_msg "B214: test t2 $MSG_MEMORY" >> "$FILE_VALGRIND_LOG" 2>&1
	    ;;
	"ta")
	    f_ckfile "r" "$g_file_in_airport"
	    g_file_in_use="$g_file_in_airport"
	    f_msg "A219: test ta $MSG_MEMORY" >> "$FILE_VALGRIND_LOG" 2>&1
	    valgrind -s --tool=memcheck --leak-check=yes              \
			--leak-check=full --show-leak-kinds=all       \
			--track-origins=yes                           \
			./jcsv -f -d 124 -avvv -o "$g_file_out"       \
	                       -e "$g_file_err" $g_file_in_airport    \
			>> "$FILE_VALGRIND_LOG" 2>&1
	    f_msg "B220: test ta $MSG_MEMORY" >> "$FILE_VALGRIND_LOG" 2>&1
	    ;;
	"tm")
	    g_file_in_use="$g_file_in_text"
	    g_file_out="$DIR_RESULTS/val_out.csv"
	    f_msg "A211: test tm $MSG_MEMORY" >> "$FILE_VALGRIND_LOG" 2>&1
	    valgrind -s --tool=memcheck --leak-check=yes              \
			--leak-check=full --show-leak-kinds=all       \
			--track-origins=yes                           \
			--keep-stacktraces=alloc-then-free            \
			./jcsv -f -M 15 -d 124 -cv                    \
	                       -o "$g_file_out" -e "$g_file_err"      \
	                       $g_file_in_text                        \
			>> "$FILE_VALGRIND_LOG" 2>&1
	    f_msg "B212: test tm $MSG_MEMORY" >> "$FILE_VALGRIND_LOG" 2>&1
	    ;;
	"tm1")
	    g_file_in_use="$g_file_in_csv"
	    f_msg "A209: test tm1 $MSG_MEMORY" >> "$FILE_VALGRIND_LOG" 2>&1
	    valgrind -s --tool=memcheck --leak-check=yes           \
			--leak-check=full --show-leak-kinds=all    \
			--track-origins=yes                        \
			--keep-stacktraces=alloc-then-free         \
			./jcsv -f -M 15 -d 124 -vvv                \
	                       -o "$g_file_out"                    \
	                       -e "$g_file_err" $g_file_in_csv     \
			>> "$FILE_VALGRIND_LOG" 2>&1
	    f_msg "B210: test tm1 $MSG_MEMORY" >> "$FILE_VALGRIND_LOG" 2>&1
	    ;;
	"tm2")
	    g_file_in_use="$g_file_in_text"
	    g_file_out="$DIR_RESULTS/val_out.csv"
	    f_msg "A207: test tm2 $MSG_MEMORY" >> "$FILE_VALGRIND_LOG" 2>&1
	    valgrind -s --tool=memcheck --leak-check=yes        \
			--leak-check=full --show-leak-kinds=all \
			--track-origins=yes                     \
			--keep-stacktraces=alloc-then-free      \
			./jcsv -f -M 15 -d 124 -cvvv            \
	                       -o "$g_file_out"                 \
	                       -e "$g_file_err" $g_file_in_text \
			>> "$FILE_VALGRIND_LOG" 2>&1
	    f_msg "B208: test tm2 $MSG_MEMORY" >> "$FILE_VALGRIND_LOG" 2>&1
	    ;;
	"tma")
	    f_ckfile "r" "$g_file_in_airport"
	    g_file_in_use="$g_file_in_airport"
	    f_msg "A205: test tma $MSG_MEMORY" >> "$FILE_VALGRIND_LOG" 2>&1
	    valgrind -s --tool=memcheck --leak-check=yes        \
			--leak-check=full --show-leak-kinds=all \
			--track-origins=yes                     \
			--keep-stacktraces=alloc-then-free      \
			./jcsv -f -M 40 -d 124 -avvv            \
	                       -o "$g_file_out"                 \
	                       -e "$g_file_err"                 \
	                       $g_file_in_airport               \
			>> "$FILE_VALGRIND_LOG" 2>&1
	    f_msg "B206: test tma $MSG_MEMORY" >> "$FILE_VALGRIND_LOG" 2>&1
	    ;;
	"tmaa")
	    g_file_in_use="$g_file_in_text"
	    f_msg "A203: test tmaa $MSG_MEMORY" >> "$FILE_VALGRIND_LOG" 2>&1
	    g_file_out="$DIR_RESULTS/val_out.csv"
	    valgrind -s --tool=memcheck --leak-check=yes        \
			--leak-check=full --show-leak-kinds=all \
			--track-origins=yes                     \
			--keep-stacktraces=alloc-then-free      \
			./jcsv -f -D '.' -o "$g_file_out"       \
	                       -e "$g_file_err"                 \
	                       -d 124 -t 2,3 -c -vvvv           \
	                       $g_file_in_text                  \
			>> "$FILE_VALGRIND_LOG" 2>&1
	    f_msg "B204: test tmaa $MSG_MEMORY" >> "$FILE_VALGRIND_LOG" 2>&1
	    ;;
	"regular")
	    f_ckfile "r" "$g_file_in_airport"
	    g_file_in_use="$g_file_in_airport"
	    f_msg "A201: test regular $MSG_MEMORY" >> "$FILE_VALGRIND_LOG" 2>&1
	    valgrind -s --tool=memcheck --leak-check=yes        \
			--leak-check=full --show-leak-kinds=all \
			--track-origins=yes                     \
			--keep-stacktraces=alloc-then-free      \
			./jcsv -afvvvv -e "$g_file_err"         \
	                       -o "$g_file_out"                 \
	                       $g_file_in_airport               \
			>> "$FILE_VALGRIND_LOG" 2>&1
	    f_msg "B202: test regular $MSG_MEMORY" >> "$FILE_VALGRIND_LOG" 2>&1
	    ;;
	"-c")
	    g_file_in_use="$g_file_in_text"
	    g_file_out="$DIR_RESULTS/val_out.csv"
	    f_msg "A201: test default $MSG_MEMORY" >> "$FILE_VALGRIND_LOG" 2>&1
	    valgrind -s --tool=memcheck --leak-check=yes        \
			--leak-check=full --show-leak-kinds=all \
			--track-origins=yes                     \
			--keep-stacktraces=alloc-then-free      \
	                ./jcsv -D '.' -d 124 -t 2,3 -c -vvvv    \
	                       -o "$g_file_out"                 \
	                       -e "$g_file_err" $g_file_in_text \
			>> "$FILE_VALGRIND_LOG" 2>&1
	    f_msg "B202: test default $MSG_MEMORY" >> "$FILE_VALGRIND_LOG" 2>&1
	    ;;
	*)
	    echo ""
	    g_is_error="Y"
	    f_help_setup
	    f_msg "W010: Required test option missing or invalid, exiting"
	    exit 2
	    ;;
    esac
    f_msg "I290: Input:   $g_file_in_use"
    f_msg "I291: Created: $g_file_out"
    f_msg "I292:          $FILE_VALGRIND_LOG"
    f_msg "I293: END   jcsv - Test Option $g_rmode $MSG_MEMORY"
    exit 0
fi

f_msg "I300: START ./jcsv - Test Option $g_rmode $MSG_MEMORY"

case "$g_rmode" in
    "t")
	g_file_in_use="$g_file_in_text"
	g_file_out="$DIR_RESULTS/val_out.csv"
	$OPENBSD_KTRACE ./jcsv -d 124 -cv $g_file_in_text > "$g_file_out" 2> "$g_file_err"
	;;
    "t0")
	g_file_in_use="$g_file_in_text"
	g_file_out="$DIR_RESULTS/val_out.csv"
	$OPENBSD_KTRACE ./jcsv -vvv -t 0 -d 124 -cv $g_file_in_text > "$g_file_out" 2> "$g_file_err"
	;;
    "t1")
	g_file_in_use="$g_file_in_csv"
	$OPENBSD_KTRACE ./jcsv -d 124 -vvv $g_file_in_csv > "$g_file_out" 2> "$g_file_err"
	;;
    "t2")
	g_file_in_use="$g_file_in_text"
	g_file_out="$DIR_RESULTS/val_out.csv"
	./jcsv -d 124 -cvvv $g_file_in_text > "$g_file_out" 2> "$g_file_err"
	;;
    "ta")
	f_ckfile "r" "$g_file_in_airport"
	g_file_in_use="$g_file_in_airport"
	$OPENBSD_KTRACE ./jcsv -d 124 -avvv $g_file_in_airport > "$g_file_out" 2> "$g_file_err"
	;;
    "tm")
	g_file_in_use="$g_file_in_text"
	g_file_out="$DIR_RESULTS/val_out.csv"
	$OPENBSD_KTRACE ./jcsv -M 15 -d 124 -cv $g_file_in_text > "$g_file_out" 2> "$g_file_err"
	;;
    "tm1")
	g_file_in_use="$g_file_in_csv"
	$OPENBSD_KTRACE ./jcsv -M 15 -d 124 -vvv $g_file_in_csv > "$g_file_out" 2> "$g_file_err"
	;;
    "tm2")
	g_file_in_use="$g_file_in_text"
	g_file_out="$DIR_RESULTS/val_out.csv"
	$OPENBSD_KTRACE ./jcsv -M 15 -d 124 -cvvv $g_file_in_text > "$g_file_out" 2> "$g_file_err"
	;;
    "tma")
	f_ckfile "r" "$g_file_in_airport"
	g_file_in_use="$g_file_in_airport"
	$OPENBSD_KTRACE ./jcsv -M 40 -d 124 -avvv $g_file_in_airport > "$g_file_out" 2> "$g_file_err"
	;;
    "tmaa")
	f_ckfile "r" "$g_file_in_airport"
	g_file_in_use="$g_file_in_airport"
	$OPENBSD_KTRACE ./jcsv -a -M 30 -d 124 -avvv $g_file_in_airport > "$g_file_out" 2> "$g_file_err"
	;;
    "regular")
	f_ckfile "r" "$g_file_in_airport"
	g_file_in_use="$g_file_in_airport"
	$OPENBSD_KTRACE ./jcsv -afvvvv $g_file_in_airport > "$g_file_out" 2> "$g_file_err"
	;;
    "-c")
	g_file_in_use="$g_file_in_text"
	g_file_out="$DIR_RESULTS/val_out.csv"
	$OPENBSD_KTRACE ./jcsv -D '.' -d 124 -t 2,3 -c -vvvv $g_file_in_text > "$g_file_out" 2> "$g_file_err"
	;;
    *)
	echo ""
	g_is_error="Y"
	f_help_setup
	f_msg "W010: Required test option missing or invalid, exiting"
	exit 2
	;;
esac


if test "$OPENBSD_KTRACE" != ""
then
    sleep 1
    kdump -u malloc
    sleep 1
    f_msg "I311: ***** Execute this:"
    f_msg "I312:       addr2line -e ./jcsv 0x????"
    f_msg "I313: ***** using the last hex val on the line for ./jcsv"
    f_msg "I314: ***** to see where the leak is (if any)"
fi

f_msg "I322: Input:   $g_file_in_use"
f_msg "I323: Created: $g_file_out"
f_msg "I324:          $g_file_err"
f_msg "I330: END   ./jcsv - Test Option $g_rmode $MSG_MEMORY"

exit 0
