.\"
.\" Copyright (c) 2014 ... 2025 2026
.\"     John McCue <jmccue@sdf.org>
.\"
.\" Permission to use, copy, modify, and distribute this software
.\" for any purpose with or without fee is hereby granted,
.\" provided that the above copyright notice and this permission
.\" notice appear in all copies.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
.\" WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
.\" THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
.\" CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
.\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\" SOFTWARE.
.\"
.TH JCSV 1 "2014-04-27" "JMC" "Local Command"
.SH NAME
jcsv - Convert csv (Comma Separated Values) File(s)
.SH SYNOPSIS
jcsv [OPTIONS] [FILE...]
.SH DESCRIPTION
Convert to/from a csv (Comma Separated Values) Text File.
.PP
Example, this line:
.nf
    "Smith","John",02/27/2013,10291,"20 Main St"
.fi
will be converted to/from:
.nf
    Smith|John|02/27/2013|10291|20 Main St
.fi
depending upon options used.
.PP
Default is to convert from csv to a straight delimited file.
.PP
If no files (FILE) are specified on the command line or
if FILE has name '-', stdin (Standard Input) is used.
.TP
-a
Optional, remove all non-7bit ASCII Characters.
Usually you should use either iconv(1) or jtr(1)
instead of this option.
.TP
-c
Optional, convert a delimited text file to a
csv (Comma Separated Value) File.
Default is to convert from a csv file to a delimited text file.
.TP
-D decimal
Optional, Decimal Point to use for numbers.
If not specified will default to a period '.'.
Only a Period or a Comma is allowed.
(see note at end)
.TP
-d delm
Optional, delimiter to use for the delimited Text File
(csv files are always comma delimited).
Supply the delimiter as a specific character or a
base 10 integer that represents the character.
For example to use:
.nf
    delm  Use arg
    ----  -------------------
    |     -d '|'  OR -d 124
    TAB   -d 9
    ^G    -d 7
.fi
If not specified, the delimiter defaults to a pipe: '|'.
.TP
-e file
Optional, if used, write error messages to file 'file'.
If not specified, errors written to stderr.
.TP
-f
Optional, Force file create.
Create file even if the target file exists.
.TP
-h
Show brief help and exit.
.TP
-M n
Set maximum Text Column Size to 'n' on the
Output File.
This is useful when creating a file for use
by utilities like psc(1).
psc(1) seems to have a maximum
text column size of 48 characters.
.TP
-o file
Optional, if used, write output to file 'file'.
If not specified, output written to stdout.
.TP
-t n,n,n,n,...
Optional, comma separated list of columns
which will be forced to be formatted as text.
n is a numeric integer used to identify the column
as a text field (ie: surround by quotes).
Set to zero to treat all columns as text (-t 0).
.TP
-V
Output version information and exit.
.TP
-v
Optional, Verbose Level.
Print information about the run on stderr,
default do not show run messages.
Can be specified multiple times,
each specification increases verbose level:
.nf
    Level  Meaning
    -----  --------------------------------------------
    = 0    Only show error messages
    >= 1   above + I/O counts
    >= 2   Parameter/Arguments used
    >= 3   above + Detail Field Split Information, can
           create a very large report
.fi

.TP
-w
Optional, write a spaces instead of an empty field.
Default is to write an empty field.
Example, default will output:
.nf
    Smith|John|20 Main St||Ntown||
.fi
where this option will output:
.nf
    Smith|John|20 Main St| |Ntown| |
.fi
.SH DIAGNOSTICS
Decimals will always be a period '.' on Output if numeric.
But, if a number in a csv file happens
to use a comma as a decimal point, specifying -D
will allow the number to be converted correctly.
Option -D is only used to determine how to format in input number.
.PP
If the first character of the Number is a Decimal Point,
a leading zero will br printed.
.PP
Note, if an error occurs while parsing command line arguments,
errors may be written stderr instead of the error file specified.
.PP
When parsing the record, leading/trailing spaces will
be removed when converting to a cvs file.
.SH SEE-ALSO
awk(1),
iconv(1),
jr(1),
jtr(1),
psc(1)
sc(1),
sed(1),
tr(1)
.SH ERROR-CODES
.nf
0 success
1 processing error or help/rev displayed
.fi
