#!/bin/sh
#
# jchar - Unit Test and Test using valgrind or ktrace
#
# Copyright (c) 2022 ... 2025 2026
#     John McCue <jmccue@sdf.org>
#
# Permission to use, copy, modify, and distribute this software
# for any purpose with or without fee is hereby granted, provided
# that the above copyright notice and this permission notice
# appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
# WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
# LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

g_dir_bhome=`dirname $0`
cd $g_dir_bhome
g_dir_bhome=`pwd`
. $g_dir_bhome/../test/tsetup.sh

g_file_err=$TMPDIR/val_err.txt
g_file_out=$TMPDIR/val_out.txt

cd $TEST_DIR_SRC
f_ckprog ./jchar

#--- test binary
if test "$PROCESS_VALGRIND" = "Y"
then
    rm $FILE_VALGRIND_LOG > /dev/null 2>&1
    f_msg "A200: START ./jchar $MSG_MEMORY" > "$FILE_VALGRIND_LOG"
    f_msg "I201: START ./jchar $MSG_MEMORY"
    valgrind -s --tool=memcheck --leak-check=yes                   \
                --leak-check=full --show-leak-kinds=all            \
                --track-origins=yes                                \
                --keep-stacktraces=alloc-then-free                 \
	        ./jchar  >> "$FILE_VALGRIND_LOG" 2>&1
    f_msg "I280: Created: $FILE_VALGRIND_LOG"
    f_msg "I281:        : $g_file_out"
    f_msg "I282:        : $g_file_err"
    if test "$TERM" = "dumb"
    then
	cat $FILE_VALGRIND_LOG
    fi
    f_msg "I290: END   ./jchar"
    f_msg "B291: END   ./jchar"     >> "$FILE_VALGRIND_LOG"
else
    f_msg "I301: START ./jchar $MSG_MEMORY"
    $OPENBSD_KTRACE ./jchar
    f_msg "I311: Created: $g_file_out"
    f_msg "I312:        : $g_file_err"
    if test "$OPENBSD_KTRACE" != ""
    then
	sleep 1
	kdump -u malloc
	sleep 1
	f_msg "I313: ***** Execute this:"
	f_msg "I314:       addr2line -e ./jchar 0x????"
	f_msg "I315: ***** using the last hex val on the line for ./jchar"
	f_msg "I316: ***** to see where the leak is (if any)"
    fi
    f_msg "I320: END   ./jchar $MSG_MEMORY"
fi

exit 0
