#!/bin/sh
#
# jascii - test with valgrind or ktrace
#
# Copyright (c) 2022 ... 2025 2026
#     John McCue <jmccue@sdf.org>
#
# Permission to use, copy, modify, and distribute this software
# for any purpose with or without fee is hereby granted, provided
# that the above copyright notice and this permission notice
# appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
# WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
# LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

g_dir_bhome=`dirname $0`
cd $g_dir_bhome
g_dir_bhome=`pwd`
. $g_dir_bhome/../test/tsetup.sh

f_create_file()
{

    (
    tr -cd '[:cntrl:]'  < /dev/urandom | fold -b -w 2 | sed 10000q
    tr -cd '[:alpha:]'  < /dev/urandom | fold    -w 2 | sed 10000q
    tr -cd '[:cntrl:]'  < /dev/urandom | fold -b -w 2 | sed 10000q
    tr -cd '[:lower:]'  < /dev/urandom | fold    -w 2 | sed 10000q
    tr -cd '[:cntrl:]'  < /dev/urandom | fold -b -w 2 | sed 10000q
    tr -cd '[:upper:]'  < /dev/urandom | fold    -w 2 | sed 10000q
    tr -cd '[:cntrl:]'  < /dev/urandom | fold -b -w 2 | sed 10000q
    tr -cd '[:punct:]'  < /dev/urandom | fold    -w 2 | sed 10000q
    tr -cd '[:alpha:]'  < /dev/urandom | fold    -w 2 | sed 10000q
    tr -cd '[:cntrl:]'  < /dev/urandom | fold -b -w 2 | sed 10000q
    tr -cd '[:xdigit]'  < /dev/urandom | fold    -w 2 | sed 10000q
    ) | $PROG_SHUFFLE | paste -d " " - - - - - - - - - - - - - - - - - - - - \
      > $g_file_in

} # END: f_create_file()

#
# main
#

g_file_in=$DIR_RESULTS/val_in.txt
g_file_err=$DIR_RESULTS/val_err.txt
g_file_out=$DIR_RESULTS/val_out.txt

cd $TEST_DIR_SRC
f_ckprog ./jascii

#--- create input file
if test ! -f "$g_file_in"
then
    f_msg "I100: Creating file $g_file_in"
    f_create_file
fi

#--- print version info
./jascii -V > "$FILE_VERSION_RESULTS" 2>&1
cat << EOF >> $FILE_MAKE_RESULTS 2>&1
=====================================================================
Source  Dir: $TEST_DIR_SRC
Results Dir: $DIR_RESULTS

Program Rev:
---------------------------------------------------------------------
`cat $FILE_VERSION_RESULTS`
=====================================================================
EOF
rm $FILE_VERSION_RESULTS $FILE_VALGRIND_LOG > /dev/null 2>&1
rm $g_file_err $g_file_out                  > /dev/null 2>&1

#--- test binary
if test "$PROCESS_VALGRIND" = "Y"
then
    f_msg "A200: START ./jascii $MSG_MEMORY" > "$FILE_VALGRIND_LOG"
    f_msg "I201: START ./jascii $MSG_MEMORY"
    valgrind -s --tool=memcheck --leak-check=yes        \
                --leak-check=full --show-leak-kinds=all \
                --track-origins=yes                     \
                --keep-stacktraces=alloc-then-free      \
	        ./jascii -f -n 50 -Lvvv -e $g_file_err  \
		         -o $g_file_out $g_file_in      \
                >> "$FILE_VALGRIND_LOG" 2>&1
    if test "$TERM" = "dumb"
    then
	cat $FILE_VALGRIND_LOG
    fi
    f_msg "I281: Created: $FILE_VALGRIND_LOG"
    f_msg "I282:          $g_file_out"
    f_msg "I283:          $g_file_err"
    f_msg "I290: END   ./jascii $MSG_MEMORY"
    f_msg "B291: END   ./jascii $MSG_MEMORY"     >> "$FILE_VALGRIND_LOG"
else
    f_msg "I300: START ./jascii $MSG_MEMORY"
    $OPENBSD_KTRACE ./jascii -f -n 50 -Lvvv \
                    -e $g_file_err -o $g_file_out $g_file_in
    f_msg "I301: Created: $g_file_out"
    f_msg "I302:          $g_file_err"
    if test "$OPENBSD_KTRACE" != ""
    then
	sleep 1
	kdump -u malloc
	sleep 1
	f_msg "I313: ***** Execute this:"
	f_msg "I314:       addr2line -e ./jascii 0x????"
	f_msg "I315: ***** using the last hex val on the line for ./jascii"
	f_msg "I316: ***** to see where the leak is (if any)"
    fi
    f_msg "I320: END   ./jascii $MSG_MEMORY"
fi

exit 0
