.\"
.\" Copyright (c) 2000 ... 2025 2026
.\"     John McCue <jmccue@sdf.org>
.\"
.\" Permission to use, copy, modify, and distribute this software
.\" for any purpose with or without fee is hereby granted,
.\" provided that the above copyright notice and this permission
.\" notice appear in all copies.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
.\" WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
.\" THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
.\" CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
.\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\" SOFTWARE.
.\"
.TH JASCII 1 "2007-01-17" "JMC" "User Commands"
.SH NAME
jascii - filter/count non-ASCII characters
.SH SYNOPSIS
jascii [OPTIONS] [FILE...]
.SH DESCRIPTION
Reads 1 or more files, optionally replace non-ASCII characters with a '*'
and write the output to stdout.
Will also count UTF-8 Bytes/Characters.
.PP
If no files (FILE) are specified on the command line or
if FILE has name "-", stdin (Standard Input) is used.
.TP
-c x
Optional, replace non-ASCII characters with character 'x'
instead of using the default of '*'.
.TP
-d c
Optional, character 'c' is used as a field delimiter.
If specified the character will be counted as
a 7-bit ASCII character.
Supply the delimiter as a specific character or a decimal
number that represents the character.
For example to use:
.nf
    delm  Use arg
    ----  -------------------
    |     -d '|'  OR -d 124
    TAB   -d 9
    ^G    -d 7
.fi
.TP
-e file
Optional, if used, write error messages to file 'file'.
If not specified, errors written to stderr.
.TP
-f
Optional, Force file create.
Create file even if the target file exists.
Default is to abort if an output file exists.
.TP
-h
Optional, show brief help and exit
.TP
-k
Optional, do not replace non-ASCII characters.
Default is to replace all non-ASCII (see -c above).
.TP
-L
Optional, print only ASCII Letters or Numbers.
Default is to print all characters (see -c above).
.TP
-l
Optional, print only ASCII Letters or Numbers or 'Special'
Characters.  This means characters between 0x21 -- 0x7E.
Default is to print all characters (see -c above).
.TP
-m n
Optional, only print the first 'n' lines.
A line is a string that ends with a new-line
character.
This can be used for both text and binary files.
Default is to process until the 100000th
new line character is found.
This prevents accidental memory crashes,
specify -m 0 to process the complete file.
.TP
-N
Optional, print only lines that contain 1 or more non-ASCII Characters.
Default is to print the complete file.
.TP
-n n
Optional, add a new lines to output to make sure
no lines exceed 'n' characters.
Default, no new-lines are inserted, new-lines will
be printed as is when found.
This can be useful when examining binary files.
.TP
-o file
Optional, if used, write output to file 'file'.
If not specified, output written to stdout.
.TP
-S
Optional, only print File statistics,
bypass display of file data.
Default is to print the data file and optionally stats (see -v below).
.TP
-V
output version information and exit.
.TP
-v
Verbose level, print file stats.
Can be specified multiple times:
.nf
    Specified What is printed with File Data
    --------- ----------------------------------------------
    0 times   Only File Data printed
    1 time    File Data with Headings
    2 times   '1 time' plus File Summary Totals & Arguments
    3 times   '2 times' plus a detail record stats
.fi

.SH EXAMPLES
List a binary file with summary totals and ensure
each print line is no longer than 60 characters:
.nf
    jascii -vv -n 60 /bin/sh
.fi
.PP
One can use jascii to generate random passwords,
to get a list of random passwords of size 20:
.nf
    jascii -n 20 -m 10 -L /dev/urandom
       or
    jascii -n 20 -m 10 -l /dev/urandom
.fi
In this case, -m stops after
finding the tenth new-line character.
.PP
Or the same can be done by:
.nf
    tr -cd "[:alnum:]" < /dev/urandom | fold -w 20 | sed 10q
.fi
But in this case you may get some non-US ASCII characters.

.SH DIAGNOSTICS
To get random data, read /dev/urandom.
On some Linux systems, reading /dev/random could
cause slow-downs as data is generated.
.PP
Logic exists to ensure the program will NOT
process forever, will stop reading after 1000000
new-lines characters are found.
For example, if processing file /dev/urandom,
the program will run until all memory is exhausted.
If you want to process the full file, no matter how
large, specify '-m 0'.
.PP
When using argument -n, new-lines are ignored.
This means lines are concatenated and split based upon the
value supplied for '-n'.
This means more records will be printed then what
was specified in '-m'.
It also means, line stats relate to each 'record' read
as opposed to what is printed.
This is due to the fact in binary files, many bytes may
be found before what is considered a line terminator.
.PP
Note, if an error occurs while parsing command line arguments,
errors may be written stderr instead of the error file specified.
.PP
UTF-8 Byte sequences are also replaced by default,
see -k above to avoid replacing.

.SH SEE-ALSO
ASCII(7),
jhd(local),
more(1),
od(1),
scat,
strings(1),
tr(1)
.SH ERROR-CODES
.nf
0 success
1 processing error or help/rev displayed
.fi
