#!/bin/sh
#
# for jadd
#
# Copyright (c) 2022 ... 2025 2026
#     John McCue <jmccue@sdf.org>
#
# Permission to use, copy, modify, and distribute this software
# for any purpose with or without fee is hereby granted, provided
# that the above copyright notice and this permission notice
# appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
# WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
# LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

g_dir_bhome=`dirname $0`
cd $g_dir_bhome
g_dir_bhome=`pwd`
. $g_dir_bhome/../test/tsetup.sh

f_bye_all()
{
    f_rmfile "$g_file_in_01"
    f_rmfile "$g_file_in_02"
    f_rmfile "$g_file_in_03"
    f_rmfile "$g_file_out"
    f_rmfile "$g_file_temp1"
    f_rmfile "$g_file_temp2"
    f_rmfile "$g_file_temp3"
} # END: f_bye_all()

f_trap()
{
    f_bye_all
    f_msg "E8000: cancelled or CTL-C pressed"
} # END: f_trap()

#
# f_create_num() - create a decimal file
#
f_create_num()
{
    f_cn_length="$1"
    f_cn_lines="$2"
    f_cn_sepr="$3"

    if test "$g_decimal_comma" = "Y"
    then
	f_cn_delm=","
    else
	f_cn_delm="."
    fi

    tr -cd '[:digit:]' < /dev/urandom | fold -w $f_cn_length \
	| sed "$f_cn_lines"q > "$g_file_temp1"
    tr -cd '[:digit:]' < /dev/urandom | fold -w 3 \
	| sed "$f_cn_lines"q > "$g_file_temp2"

    paste -d "$f_cn_delm" "$g_file_temp1" "$g_file_temp2" \
	| sed '1s/^/-/;2s/^./x/;3s/.$/-/;4,$s/^0/-/;s/^-0*/-/' > "$g_file_temp3"

    if test "$g_create_flat" = "Y"
    then
	awk '{printf("%-40s %25s\n", "Test is a flat fixed length file", $1)}' \
	    < "$g_file_temp3"
    else
	seq 1 $f_cn_lines > "$g_file_temp1"
	paste -d " " "$g_file_temp1" "$g_file_temp3" \
	    | awk '{printf("1|2|REC-%s||DELIMITED-5|%s|A7|A8||A10\n", $1,$2)}'
    fi

    f_rmfile "$g_file_temp1"
    f_rmfile "$g_file_temp2"
    f_rmfile "$g_file_temp3"

    if test "$f_cn_sepr" = "Y"
    then
	if test "$g_create_flat" = "Y"
	then
	    if test "$g_decimal_comma" = "Y"
	    then
		echo "1.234.567,123" \
		    | awk '{printf("%-40s %25s\n", "Test is a flat fixed length file", $1)}'
		echo "1.234.567,123-" \
		    | awk '{printf("%-40s %25s\n", "Test is a flat fixed length file", $1)}'
	    else
		echo "1,234,567.123" \
		    | awk '{printf("%-40s %25s\n", "Test is a flat fixed length file", $1)}'
		echo "1,234,567.123-" \
		    | awk '{printf("%-40s %25s\n", "Test is a flat fixed length file", $1)}'
	    fi
	else
	    if test "$g_decimal_comma" = "Y"
	    then
		echo "0" "1.234.567,123" \
			| awk '{printf("1|2|REC-%s||DELIMITED-5|%s|A7|A8||A10\n", $1,$2)}'
		echo "0" "1.234.567,123-" \
			| awk '{printf("1|2|REC-%s||DELIMITED-5|%s|A7|A8||A10\n", $1,$2)}'
	    else
		echo "0" "1,234,567.123" \
			| awk '{printf("1|2|REC-%s||DELIMITED-5|%s|A7|A8||A10\n", $1,$2)}'
		echo "0" "1,234,567.123-" \
			| awk '{printf("1|2|REC-%s||DELIMITED-5|%s|A7|A8||A10\n", $1,$2)}'
	    fi
	fi
    fi

} # END: f_create_num()

#
# main
#

g_file_in_01=$DIR_RESULTS/val_in_01.txt
g_file_in_02=$DIR_RESULTS/val_in_02.txt
g_file_in_03=$DIR_RESULTS/val_in_03.txt
g_file_err=$DIR_RESULTS/val_err.txt
g_file_out=$DIR_RESULTS/val_out.txt
g_file_temp1=$DIR_RESULTS/temp_01.txt
g_file_temp2=$DIR_RESULTS/temp_02.txt
g_file_temp3=$DIR_RESULTS/temp_03.txt

g_arg_point=""
g_arg_col=""
g_arg_dlm=""
g_create_flat=""
g_create_delm=""
g_decimal_comma=""

g_create_flat="N"
g_decimal_comma="N"

#--- process options
case "$TEST_ARG" in
    "-dp")     # Use Delimited  Input with Decimal Point of a period
	g_create_flat="N"
	g_decimal_comma="N"
	;;
    "-fp")     # Use Flat Fixed Input with Decimal Point of a period
	g_create_flat="Y"
	g_decimal_comma="N"
	;;
#NOT YET#    "-dc")     # Use Delimited  Input with Decimal Point of a comma
#NOT YET#	g_create_flat="N"
#NOT YET#	g_decimal_comma="Y"
#NOT YET#	;;
#NOT YET#    "-fc")     # Use Flat Fixed Input with Decimal Point of a comma
#NOT YET#	g_create_flat="Y"
#NOT YET#	g_decimal_comma="Y"
#NOT YET#	;;
    *)
	echo ""
	g_is_error="Y"
	f_help_setup
	f_msg "W0010: Required test option missing or invalid, exiting"
	exit 2
	;;
esac

#--- set processing mode
if test "$g_create_flat" = "Y"
then
    g_arg_col="-C 40"
    g_arg_dlm=""
else
    g_arg_col="-C 6"
    g_arg_dlm="-d 124"
fi
if test "$g_decimal_comma" = "Y"
then
    g_arg_point="-d ,"
else
    g_arg_point=""
fi

cd $TEST_DIR_SRC
f_ckprog ./jadd

trap f_trap INT TERM

f_msg "I0100: Creating test Files"
rm $g_file_in_01 $g_file_in_02 $g_file_in_03 \
   $g_file_err   $g_file_out   > /dev/null 2>&1
f_create_num 3  5   "Y" > "$g_file_in_01"
f_create_num 10 200 "N" > "$g_file_in_02"
f_create_num 15 300 "N" > "$g_file_in_03"

#--- print version info
./jadd -V > "$FILE_VERSION_RESULTS" 2>&1
cat << EOF >> $FILE_MAKE_RESULTS 2>&1
=====================================================================
Source  Dir: $TEST_DIR_SRC
Results Dir: $DIR_RESULTS

Program Rev:
---------------------------------------------------------------------
`cat $FILE_VERSION_RESULTS`
=====================================================================
EOF
rm $FILE_VERSION_RESULTS $FILE_VALGRIND_LOG > /dev/null 2>&1

#--- execute the test
if test "$PROCESS_VALGRIND" = "Y"
then
    f_msg "A0200: START ./jadd $MSG_MEMORY" > "$FILE_VALGRIND_LOG"
    f_msg "I0201: START ./jadd $MSG_MEMORY"
    valgrind -s --tool=memcheck --leak-check=yes                   \
                --leak-check=full --show-leak-kinds=all            \
                --track-origins=yes                                \
                --keep-stacktraces=alloc-then-free                 \
	        ./jadd -f -vvvvv -o $g_file_out                           \
                       -e $g_file_err  $g_arg_col $g_arg_dlm $g_arg_point \
                       "$g_file_in_01" "$g_file_in_02" "$g_file_in_03"             \
                >> "$FILE_VALGRIND_LOG" 2>&1
    f_msg "I0280: Created: $FILE_VALGRIND_LOG"
    f_msg "I0281:        : $g_file_out"
    f_msg "I0282:        : $g_file_err"
    if test "$TERM" = "dumb"
    then
	cat $FILE_VALGRIND_LOG
    fi
    f_msg "I0290: END   ./jadd $MSG_MEMORY"
    f_msg "B0291: END   ./jadd $MSG_MEMORY"     >> "$FILE_VALGRIND_LOG"
else
    f_msg "I0300: START ./jadd $MSG_MEMORY"
    $OPENBSD_KTRACE ./jadd -f -vvvvv -o $g_file_out           \
            -e $g_file_err $g_arg_col $g_arg_dlm $g_arg_point \
            "$g_file_in_01" "$g_file_in_02" "$g_file_in_03"
    f_msg "I0311: Created: $g_file_out"
    f_msg "I0312:        : $g_file_err"
    if test "$OPENBSD_KTRACE" != ""
    then
	sleep 1
	kdump -u malloc
	sleep 1
	f_msg "I313: ***** Execute this:"
	f_msg "I314:       addr2line -e ./jadd 0x????"
	f_msg "I315: ***** using the last hex val on the line for ./jadd"
	f_msg "I316: ***** to see where the leak is (if any)"
    fi
    f_msg "I0330: END   ./jadd $MSG_MEMORY"
fi

f_rmfile "$g_file_temp1"
f_rmfile "$g_file_temp2"
f_rmfile "$g_file_temp3"

exit 0
