/*
 * Copyright (c) 1975, 1993 ... 2025 2026
 *     John McCue <jmccue@sdf.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/*
 * Generated by mk_long_help.sh on Sun Nov 29 16:55:00 EST 2009
 */
#ifndef _MSDOS
#include <sys/param.h>
#endif
#include <stdio.h>
#include <stdlib.h>

#ifdef HAVE_JLIB
#include <j_lib2.h>
#include <j_lib2m.h>
#endif

#include "bike.h"

int show_help_long(FILE *fp)
{

  fprintf(fp, "bike(1)                                                                bike(1)\n");
  fprintf(fp, "\n");
  fprintf(fp, "\n");
  fprintf(fp, "\n");
  fprintf(fp, "NAME\n");
  fprintf(fp, "       bike - Calculate Bike Gear Inches\n");
  fprintf(fp, "\n");
  fprintf(fp, "SYNOPSIS\n");
  fprintf(fp, "       bike OPTIONS\n");
  fprintf(fp, "\n");
  fprintf(fp, "DESCRIPTION\n");
  fprintf(fp, "       Calculate Bicycle Gear Inches.\n");
  fprintf(fp, "\n");
  fprintf(fp, "OPTIONS\n");
  fprintf(fp, "       %ce file\n", SWITCH_CHAR);
  fprintf(fp, "              Optional,  errors  written  to  the  file specified, defaults to\n");
  fprintf(fp, "              stderr.\n");
  fprintf(fp, "\n");
  fprintf(fp, "       %cF n,n,n,...,n\n", SWITCH_CHAR);
  fprintf(fp, "              Required, n = Number of Teeth on each Front Sprocket.  This is a\n");
  fprintf(fp, "              comma separated list of numeric values, one value for each front\n");
  fprintf(fp, "              sprocket.  Order is not important.\n");
  fprintf(fp, "\n");
  fprintf(fp, "       %cf     Force file create.  Create file even if the target file exists.\n", SWITCH_CHAR);
  fprintf(fp, "\n");
  fprintf(fp, "       %ch     Optional, show brief help and  exit.   If  specified  more  than\n", SWITCH_CHAR);
  fprintf(fp, "              once, show detail help on stdout instead.\n");
  fprintf(fp, "\n");
  fprintf(fp, "       %co file\n", SWITCH_CHAR);
  fprintf(fp, "              Optional, write output to the file specified, defaults  to  std-\n");
  fprintf(fp, "              out.\n");
  fprintf(fp, "\n");
  fprintf(fp, "       %cp     Optional,  use PI when generating inches per 'pedal', ie: (ratio\n", SWITCH_CHAR);
  fprintf(fp, "              * PI).  Defaults to ((ratio / 60) * 185).\n");
  fprintf(fp, "\n");
  fprintf(fp, "       %cR n,n,n,...,n\n", SWITCH_CHAR);
  fprintf(fp, "              Required, n = Number of Teeth on each Rear Sprocket.  This is  a\n");
  fprintf(fp, "              comma  separated list of numeric values, one value for each rear\n");
  fprintf(fp, "              sprocket.  Order is not important.\n");
  fprintf(fp, "\n");
  fprintf(fp, "       %ct string\n", SWITCH_CHAR);
  fprintf(fp, "              Optional string to display as the Report Title.\n");
  fprintf(fp, "\n");
  fprintf(fp, "       %cv     Optional, verbose report.  Show Detail  Gear  Inch  Information.\n", SWITCH_CHAR);
  fprintf(fp, "              Defaults  is  to  only show Gear Matrix Chart.  This option will\n");
  fprintf(fp, "              show these items per gear inch:\n");
  fprintf(fp, "                  o Inches per each Pedal Revolution\n");
  fprintf(fp, "                  o Feet per each Pedal Revolution\n");
  fprintf(fp, "                  o Miles per each Pedal Revolution\n");
  fprintf(fp, "                  o Number of Pedals per Mile\n");
  fprintf(fp, "                  o MPH at 70 RPM (pedals per minute)\n");
  fprintf(fp, "                  o MPH at 80 RPM (pedals per minute)\n");
  fprintf(fp, "                  o MPH at 90 RPM (pedals per minute)\n");
  fprintf(fp, "                  o MPH at 100 RPM (pedals per minute)\n");
  fprintf(fp, "                  o MPH at 110 RPM (pedals per minute)\n");
  fprintf(fp, "\n");
  fprintf(fp, "       %cV     Optional, output version information and exit.\n", SWITCH_CHAR);
  fprintf(fp, "\n");
  fprintf(fp, "       %cw size\n", SWITCH_CHAR);
  fprintf(fp, "              Required, wheel size, can be either inches or cm.  If  'size'  <\n");
  fprintf(fp, "              100, assumes inches, > 99 assumes cm.\n");
  fprintf(fp, "\n");
  fprintf(fp, "\n");
  fprintf(fp, "DIAGNOSTICS\n");
  fprintf(fp, "       Option PI does not effect gear inches, it will only change the calcula-\n");
  fprintf(fp, "       tions used in the verbose report.\n");
  fprintf(fp, "\n");
  fprintf(fp, "       Does not produce 100%% exact gear  inches.   Tire  width,  pressure  and\n");
  fprintf(fp, "       other  factors  could  generate different results, but it gives a close\n");
  fprintf(fp, "       approximation.  For more exact values see site:\n");
  fprintf(fp, "       http://www.sheldonbrown.com/gears/\n");
  fprintf(fp, "\n");
  fprintf(fp, "       Right now, the maximum number of sprockets for both front and  rear  is\n");
  fprintf(fp, "       50,  this gives a maximum of 2500 gears.  I doubt any bicycle will ever\n");
  fprintf(fp, "       come close to that number of sprockets.\n");
  fprintf(fp, "\n");
  fprintf(fp, "\n");
  fprintf(fp, "BUGS\n");
  fprintf(fp, "       Do not know of any.\n");
  fprintf(fp, "\n");
  fprintf(fp, "\n");
  fprintf(fp, "ENVIRONMENT\n");
  fprintf(fp, "       none.\n");
  fprintf(fp, "\n");
  fprintf(fp, "\n");
  fprintf(fp, "ERROR CODES\n");
  fprintf(fp, "       0 success\n");
  fprintf(fp, "       1 processing error or help/rev displayed\n");
  fprintf(fp, "\n");
  fprintf(fp, "\n");
  fprintf(fp, "\n");
  fprintf(fp, "                                                                       bike(1)\n");

  return(EXIT_FAILURE);

} /* show_help_long() */
