#!/bin/sh

unset VERBOSE
#VERBOSE=-v

if test -x ./bike
then
    BIKE=./bike
else
    if test -x /usr/local/bin/bike
    then
	BIKE=/usr/local/bin/bike
    else
	echo "E01 -- could not find bike executable"
	exit 2
    fi
fi
export BIKE

rm -f report.prn

$BIKE -w 700 $VERBOSE -F 22,34,42 -R 28,24,21,18,16,14,12       -t "Trek 750, Gearing, Aug 1997, reading 7,952"             >> report.prn
$BIKE -w 700 $VERBOSE -F 22,34,42 -R 30,24,21,18,15,13,11       -t "Trek 750, Gearing, Aug 1998, Reading 11,771"            >> report.prn
$BIKE -w 700 $VERBOSE -F 22,32,44 -R 28,24,21,18,16,14,12       -t "Trek 750, Gearing, Jun 2004 / 25,734 Aug 2009 / 34,554" >> report.prn

$BIKE -w 26  $VERBOSE -F 48,36,26 -R 11,13,15,17,20,23,26,30,34 -t "Surly LHT -- Factory"                                   >> report.prn
$BIKE -w 26  $VERBOSE -F 22,34,44 -R 12,14,16,18,21,24,28       -t "Surly LHT -- Possible 1"                                >> report.prn
$BIKE -w 26  $VERBOSE -F 24,36,46 -R 12,14,16,18,21,24,28       -t "Surly LHT -- Possible 4"                                >> report.prn
$BIKE -w 26  $VERBOSE -F 22,36,46 -R 12,14,16,18,21,24,28       -t "Surly LHT -- Possible 3"                                >> report.prn
$BIKE -w 26  $VERBOSE -F 22,36,44 -R 12,14,16,18,21,24,28       -t "Surly LHT -- Possible 2"                                >> report.prn
$BIKE -w 26  $VERBOSE -F 22,32,44 -R 12,14,16,18,21,24,28       -t "Surly LHT as of Sep 2009"                               >> report.prn
# possible ?
$BIKE -w 26  $VERBOSE -F 22,34,44 -R 13,15,17,19,21,23,26,30    -t "Possible in 2010"                                       >> report.prn
$BIKE -w 26  $VERBOSE -F 22,32,44 -R 13,15,17,19,21,23,26,30    -t "With new cogs"                                          >> report.prn


##$BIKE -w 700 $VERBOSE -f 48,36,26 -r 11,13,15,17,20,23,26,30,32 -t "Trek 520, rear guess -- Factory"                        >> report.prn
