.\"
.\" Copyright (c) 1993 ... 2025 2026
.\"     John McCue <jmccue@sdf.org>
.\"
.\" Permission to use, copy, modify, and distribute this software
.\" for any purpose with or without fee is hereby granted,
.\" provided that the above copyright notice and this permission
.\" notice appear in all copies.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
.\" WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
.\" THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
.\" CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
.\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\" SOFTWARE.
.\"
.TH BIKE 1 "1996-10-23" "JMC" "User Commands"
.SH NAME
bike - Calculate Bike Gear Inches
.SH SYNOPSIS
bike OPTIONS
.SH DESCRIPTION
Calculate Bicycle Gear Inches.
.SH OPTIONS
.TP
-e file
Optional, errors written to the file specified, defaults to stderr.
.TP
-F n,n,n,...,n
Required, n = Number of Teeth on each Front Sprocket.
This is a comma separated list of numeric values,
one value for each front sprocket.
Order is not important.
.TP
-f
Force file create.
Create file even if the target file exists.
.TP
-h
Optional, show brief help and exit.
If specified more than once, show detail help on stdout instead.
.TP
-o file
Optional, write output to the file specified, defaults to stdout.
.TP
-p
Optional, use PI when generating inches per 'pedal', ie: (ratio * PI).
Defaults to ((ratio / 60) * 185).
.TP
-R n,n,n,...,n
Required, n = Number of Teeth on each Rear Sprocket.
This is a comma separated list of numeric values,
one value for each rear sprocket.
Order is not important.
.TP
-t string
Optional string to display as the Report Title.
.TP
-v
Optional, verbose report.
Show Detail Gear Inch Information.
Defaults is to only show Gear Matrix Chart.
This option will show these items per gear inch:
.nf
    o Inches per each Pedal Revolution
    o Feet per each Pedal Revolution
    o Miles per each Pedal Revolution
    o Number of Pedals per Mile
    o MPH at 70 RPM (pedals per minute)
    o MPH at 80 RPM (pedals per minute)
    o MPH at 90 RPM (pedals per minute)
    o MPH at 100 RPM (pedals per minute)
    o MPH at 110 RPM (pedals per minute)
.fi
.TP
-V
Optional, output version information and exit.
.TP
-w size
Required, wheel size, can be either inches or cm.
If 'size' < 100, assumes inches, > 99 assumes cm.
.SH DIAGNOSTICS
Option PI does not effect gear inches, it will only
change the calculations used in the verbose report.
.PP
Does not produce 100% exact gear inches.
Tire width, pressure and other factors could
generate different results, but it gives a close
approximation.
For more exact values see site:
.nf
http://www.sheldonbrown.com/gears/
.fi
.PP
Right now, the maximum number of sprockets
for both front and rear is 50, this gives
a maximum of 2500 gears.
I doubt any bicycle will ever come close
to that number of sprockets.
.SH BUGS
Do not know of any.
.SH ENVIRONMENT
none.
.SH ERROR CODES
.nf
0 success
1 processing error or help/rev displayed
.fi
