.\"
.\" Copyright (c) 2020 ... 2025 2026
.\"     John McCue <jmccue@sdf.org>
.\"
.\" Permission to use, copy, modify, and distribute this software
.\" for any purpose with or without fee is hereby granted,
.\" provided that the above copyright notice and this permission
.\" notice appear in all copies.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
.\" WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
.\" THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
.\" CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
.\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\" SOFTWARE.
.\"
.TH ADD_DAY 1 "2020-11-17" "JMC" "User Commands"
.SH NAME
add_day - Generates a list of Consecutive Dates
.SH SYNOPSIS
add_day [OPTIONS]
.SH DESCRIPTION
Generates a list of consecutive dates.
This list can be useful in Shell scripts.
You will need to specify a Date Range, which
is used to generate the list.
.PP
The list is generated by starting with the
Low Date and adds one to the date,
printing the results.
Processing will stop once High Date is reached.
.PP
Only uses stdout and strerr.
There is no Input.
.TP
-F n
Optional, Format of the Output Date.
If not specified, format will be YYYYMMDD.
.nf
    n  Use Format
    -  ----------
    0  YYYYMMDD
    1  YYYY/MM/DD
    2  YYYY-MM-DD
    3  MM/DD/YYYY
    4  DD-MM-YYYY
.fi
.TP
-h
Show brief help and exit.
.TP
-L date
Optional, Low Value for the Date Range.
Format of 'date' is YYYYMMDD.
If not specified, will default to Today's Date.
.TP
-M date
Optional, High Value for the Date Range.
Format of 'date' is YYYYMMDD.
If not specified, will default to the Last Day
of the Current Month.
.TP
-V
Output version information and exit.
.SH EXAMPLE
If you issue this command:
.nf
add_day -L 20200101 -M 20200107

the following is printed:

20200101
20200102
20200103
20200104
20200105
20200106
20200107
.fi
.SH DIAGNOSTICS
Nothing is printed if you specify
a Low Date that is greater than the High Date.
.SH SEE-ALSO
awk(1),
sed(1)
.SH ERROR-CODES
.nf
0 success
1 processing error or help/rev displayed
.fi
