#!/usr/pkg/bin/perl

###############################################
# Greymatter 1.3                              #
# main program                                #
# Copyright (c)2000-2003, The Greymatter team #
# http://www.greymatterforums.com/            #
###############################################

# ***  Your possession of this software indicates that you agree to the terms   ***
# *** specified under the "Copyright & Usage" heading in the "manual.htm" file. ***

eval {
	($0 =~ m,(.*)/[^/]+,) && unshift (@INC, "$1");
	($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1");
};

use CGI::Carp qw(fatalsToBrowser);

require "gm-library.cgi";

# ----------------------------------------
# gathering the input & checking for login
# ----------------------------------------

print "Content-type: text/html\n\n";

$authorIP = $ENV{'REMOTE_ADDR'};

$logindeletednotice = "";

if ($ENV{'REQUEST_METHOD'} eq "GET") { $getin = $ENV{'QUERY_STRING'}; } else { read(STDIN, $getin, $ENV{'CONTENT_LENGTH'}); }

@pairs = split(/&/, $getin);
foreach $pair (@pairs) {
	($name, $value) = split(/=/, $pair);
	$name =~ tr/+/ /;
	$name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	unless (($name eq "logtext") || ($name eq "loglink")) { $value =~ tr/+/ /; }
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	$IN{$name} = $value;
}

&gm_bancheck;
&gm_readconfig;

if ($IN{'thomas'} eq "") { &gm_login; }
if ($IN{'thomas'} eq "Re-Login") { &gm_login; }

&gm_validate;

if ($IN{'thomas'} eq "login") {
	&gm_writetocplog("<B>$IN{'authorname'} logged in</B>");
	&gm_versioncheck;
	&gm_readcounter;
	$statusnote = qq(<B><FONT COLOR="#0000FF">Welcome, $IN{'authorname'}.</FONT></B><P>);
	if ($newentrynumber eq "0") {
		open (FUNNYFEET, "gm-cplog.cgi") || &gm_dangermouse("Can't read the control panel log.  Please make sure that gm-cplog.cgi is CHMODed to 666 and is in the same place as all your other Greymatter CGI files; also try running Diagnostics & Repair from the Configuration screen.");
		@cploglines = <FUNNYFEET>;
		close (FUNNYFEET);
		$cplogtext = join (" ", @cploglines);
		unless ($cplogtext =~ /successfully performed diagnostics/) {
			$statusnote = qq(<B><FONT COLOR="#0000FF">Welcome to Greymatter!  Please enter Configuration first, check your paths,<BR>and run Diagnostics & Repair to validate your installation.</FONT></B><P>);
		}
	}
	&gm_frontpage;
}

if ($IN{'thomas'} eq "rebuildupdate") { &gm_rebuildupdate; }

if ($IN{'thomas'} eq "Update Now") { &gm_versionupgrading; }

if ($IN{'thomas'} eq "gmbmpost") { &gm_addentrypopup; }

if ($IN{'thomas'} eq "Return To Main Menu") { &gm_frontpage; }

if ($IN{'thomas'} eq "Add A New Entry") { &gm_addentry; }
if ($IN{'thomas'} eq "Edit An Entry") { &gm_editentryselection; }
if ($IN{'thomas'} eq "Configuration") { &gm_configuration; }
if ($IN{'thomas'} eq "Edit Templates") { &gm_edittemplates; }
if ($IN{'thomas'} eq "Edit Authors") { &gm_editauthors; }
if ($IN{'thomas'} eq "Edit Banned IP List") { &gm_editbanlist; }
if ($IN{'thomas'} eq "Add Bookmarklets") { &gm_addbookmarklets; }
if ($IN{'thomas'} eq "Upload Files") { &gm_uploadfiles; }
if ($IN{'thomas'} eq "Rebuild Files") { &gm_rebuildfilesmenu; }
if ($IN{'thomas'} eq "View Control Panel Log") { &gm_viewcplog; }

if ($IN{'thomas'} eq "Add This Entry") { &gm_savenewentry; }
if ($IN{'thomas'} eq "Preview Before Posting") { &gm_previewentry; }

if ($IN{'thomas'} eq "Re-Edit This Entry") {
	if ($IN{'gmbmspecial'} eq "popupblog") { &gm_addentrypopup; } else { &gm_addentry; }
}

if ($IN{'thomas'} eq "Change View") { &gm_editentryselection; }
if ($IN{'thomas'} eq "Search") { &gm_editentryselection; }
if ($IN{'thomas'} eq "Edit Selected Entry") { &gm_editthisentry; }
if ($IN{'thomas'} eq "Open/Close Selected Entry") { &gm_changeentryopenstatus; }
if ($IN{'thomas'} eq "Search And Replace Across All Entries") { &gm_editentrysearchandreplace; }

if ($IN{'thomas'} eq "Edit Selected Comment") { &gm_editselectedcomment; }
if ($IN{'thomas'} eq "Delete Selected Comment") { &gm_deleteselectedcomment; }
if ($IN{'thomas'} eq "Save Changes To This Entry") { &gm_saveentrychanges; }
if ($IN{'thomas'} eq "Select Another Entry") { &gm_editentryselection; }

if ($IN{'thomas'} eq "Return To Entry Selection") { &gm_editentryselection; }

if ($IN{'thomas'} eq "Perform Search And Replace") { &gm_performsearchandreplace; }

if ($IN{'thomas'} eq "Save Changes To This Comment") { &gm_savecommentchanges; }
if ($IN{'thomas'} eq "Return To Entry Editing") { &gm_editthisentry; }

if ($IN{'thomas'} eq "Add New IP") { &gm_addbannedip; }
if ($IN{'thomas'} eq "Delete Selected IP") { &gm_deletebannedip; }

if ($IN{'thomas'} eq "Diagnostics & Repair") { &gm_diagnosticscheck; }
if ($IN{'thomas'} eq "Save Configuration") { &gm_saveconfiguration; }

if ($IN{'thomas'} eq "Perform Diagnostics & Repair") { &gm_diagnosticsperform; }
if ($IN{'thomas'} eq "Return To Configuration") { &gm_configuration; }

if ($IN{'thomas'} eq "Edit Main Index-Related Templates") { &gm_editmainindextemplates; }
if ($IN{'thomas'} eq "Edit Archive-Related Templates") { &gm_editarchivetemplates; }
if ($IN{'thomas'} eq "Edit Entry Page-Related Templates") { &gm_editentrypagetemplates; }
if ($IN{'thomas'} eq "Edit Karma & Comments-Related Templates") { &gm_editkarmacommentstemplates; }
if ($IN{'thomas'} eq "Edit Header, Footer & Sidebar Templates") { &gm_editheaderfootertemplates; }
if ($IN{'thomas'} eq "Edit Miscellaneous Templates") { &gm_editmisctemplates; }

if ($IN{'thomas'} eq "Return To Templates Menu") { &gm_edittemplates; }
if ($IN{'thomas'} eq "Save Template Changes") { &gm_savetemplatechanges; }

if ($IN{'thomas'} eq "Edit Selected Author") { &gm_editselectedauthor; }
if ($IN{'thomas'} eq "Delete Selected Author") { &gm_deleteselectedauthor; }
if ($IN{'thomas'} eq "Create New Author") { &gm_createnewauthor; }

if ($IN{'thomas'} eq "Save Changes To This Author") { &gm_saveauthorchanges; }
if ($IN{'thomas'} eq "Return To Author Panel") { &gm_editauthors; }

if ($IN{'thomas'} eq "Upload This File") { &gm_processupload; }

if ($IN{'thomas'} eq "Rebuild Last Entry Page Only") { &gm_rebuildlastentrypageonly; }
if ($IN{'thomas'} eq "Rebuild Main Index File") { &gm_rebuildmainindexfile; }
if ($IN{'thomas'} eq "Rebuild Main Entry Pages") { &gm_rebuildmainentrypages; }
if ($IN{'thomas'} eq "Rebuild Archive Master Index") { &gm_rebuildarchivemasterindex; }
if ($IN{'thomas'} eq "Rebuild Archive Log Indexes") { &gm_rebuildarchivelogindexes; }
if ($IN{'thomas'} eq "Rebuild Archive Entry Pages") { &gm_rebuildarchiveentrypages; }
if ($IN{'thomas'} eq "Rebuild All Entry Pages") { &gm_rebuildallentrypages; }
if ($IN{'thomas'} eq "Rebuild Connected Files") { &gm_rebuildconnectedfilescheck; }
if ($IN{'thomas'} eq "Rebuild Everything") { &gm_rebuildeverything; }

if ($IN{'thomas'} eq "Clear And Exit") {
	unlink ("$EntriesPath/gmrightclick-$IN{'usethisauthorname'}.reg");
	&gm_frontpage;
}

if ($IN{'thomas'} eq "Reset The Control Panel Log") { &gm_resetcplog; }

if ($IN{'thomas'} eq "Include This Image In A New Entry") { &gm_addentry; }
if ($IN{'thomas'} eq "Include In Entry As A Popup Window") {
	$IN{'newentrymaintext'} = $IN{'newentrypopuptext'};
	&gm_addentry;
}
if ($IN{'thomas'} eq "Include This Link In A New Entry") { &gm_addentry; }

exit;
