# Copyright 2001, 2002 Benjamin Trott. This code cannot be redistributed without
# permission from www.movabletype.org.
#
# $Id: ObjectDriver.pm,v 1.5 2002/01/05 22:46:07 btrott Exp $

package MT::ObjectDriver;
use strict;

use MT::ConfigMgr;

use MT::ErrorHandler;
@MT::ObjectDriver::ISA = qw( MT::ErrorHandler );

sub new {
    my $class = shift;
    my $type = shift;
    $class .= "::" . $type;
    eval "use $class;";
    die "Unsupported driver $class: $@" if $@;
    my $driver = bless {}, $class;
    $driver->init(@_);
}

sub init {
    my $driver = shift;
    $driver->{cfg} = MT::ConfigMgr->instance;
    $driver;
}

sub cfg { $_[0]->{cfg} }

sub load;
sub exists;
sub save;

1;
