/*
    jugtail.conf.h, written by Rhett "Jonzy" Jones

    Jonzy's Universal Gopher Hierarchy Excavation And Display.
    Excavates through gopher menus and displays the hierarchy
    of the menus encountered

    Copyright (C) 1993, 1994 University of Utah Computer Center.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program (look for the file called COPYING);
    if not, write to the Free Software Foundation, Inc.,
        51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
	                                                                 */

/* Description:	Configuration file for jugtail.  This header file is where
 *		you define site specific definitions. */


#ifndef JUGTAIL_CONF_H
#define JUGTAIL_CONF_H

/* NOTE: All variables in this file can be altered modified by using
 * the jugtail.conf file respectivly.  For more information on the uses
 * of these variables please see the jugtail.conf document. */

/* This is the name of the machine jugtail is running on.
 * If "hostname" from the system prompt returns the
 * Fully Qualified Domain Name of the machine jugtail is to
 * run on you can leave HOSTDOMAIN = "", otherwise put here what
 * is missing.  For example: at your system prompt enter: hostname
 * if it says "name" and the Fully Qualified Domain Name is:
 * "name.some.domain" you need to put ".some.domain" here.
 * Note: jugtail requires Fully Qualified Domain Names.
 * This variable can be altered using the jugtail.conf file. */
#define HOSTDOMAIN	""

/* This is the gopher information stating where the "ABOUT" document
 * is located.  This string is passed back to the gopher client with the error
 * encountered as the menu title.  This string consists of is a tab followed by
 * the selector string or Path, with another tab, the host, tab, and finaly the
 * port.  If you don't want any of this information displayed use the definition
 * that is commented out.  I should mention that my "About jugtail" document
 * contains information about the last time the database was built and the
 * number of entries found.  If you don't want this feature use the following:
 * #define JUGTAILHELP	"\t\terror.host\t-1"
 * This variable can be altered using the jugtail.conf file. */
#define JUGTAILHELP	"\t0/Search menu titles using jughead/About jughead\tgopher.cc.utah.edu\t70\r\n"

/* There are a couple of cases where an error message is generate and
 * the client making the query needs to be informed.  Here you can define
 * the selector-string, the-host, and the-port for the message.  In this
 * case if the user attempts to open the error message from gopher they
 * get the "About jughead" document.  If you dont't like this option
 * use the following:
 * #define ERRORHOST	"\t\terror.host\t-1"
 * This variable can be altered using the jugtail.conf file. */
#define ERRORHOST	JUGTAILHELP

/* The port to fire the search engine under.  If you get a
 * "can't bind" error as a search engine the port is being used.*/
#define PORT2USE	3000

/* This is the default maximum number of jugtail processes that can be
 * forked.  This value can be changed from the command line with the
 * use of the -M flag.	*/
#define MAXPROCS	5

/* These are the characters that delimit a word when doing a search. */
#define DELIMITERS	" \t\n\f\r !\"#$%&\'()+,-./:;<=>?@[\\]^_`{|}~" 

/* The maximum items to return before giving a message and requiring
 * the use of ?all or ?range= special commands. */
#define MAXITEMS2RETURN	1024

/* This is the default boolean operation to perform when searching, when
 * there exists no boolean operator between words.  It can be one of
 * "AND", "OR", "NOT", but I have no idea why you would select "NOT". */
#define DEFAULTBOOLOP	"AND"

/* This is where you can change the name of the your local jugtail title
 * to make jugtail more specific to your site.	*/
#define JUGTAILHELPTITL	"jugtail help"

/* This is the string "usage error" and may be changed to your local
 * language.  */
#define USAGERROR	"usage error"

/* The defines WILDCARDERR, TOMNYPRCSERR, NOFORKERR, GTSTRERR, READERR
 * are strings to be sent the gopher client if an error was encountered.
 * The leading character '3' is a gopher error item.  If you prefer these
 * gopher items to point to your "About jugtail" document with use of
 * JUGTAILHELP change the '3' to a '0' (zero), which is a gopher text
 * item.  You can change of these errors to make jugtail more specific
 * to your local site.  */
#define WILDCARDERR	"3Invalid wildcard usage"
#define TOMNYPRCSERR	"3Too many processes.  (Please try later)"
#define NOFORKERR	"3jugtail could not fork"
#define GTSTRERR	"3GetString: Timed out"
#define READERR		"3ProcessRequest: readline error"


/* The location to place any temporary files name. */
#define TMPFILENAME	"/tmp/jugtail.tmp"

/* The following defines should have the full pathway to the executable.  To
 * determine this do a "which COMMAND", where COMMAND is cat, rm, sort,
 * or touch.  */

/* CATCOMMAND it the cat system command to use. */

/* SORTCOMMAND is the system dependent call to "sort".  It needs to be a call
 * to sort such that we only sort on text after the first tab character.  In
 * this sort command the first "%s" is the name of the resultant sorted file,
 * and the second "%s" is the name of the file to have sorted.  The "-T /tmp"
 * says to use /tmp as the place for any temporary files.  The use of sort is
 * not tosort the data but to remove any duplicates that may have been written
 *to the file.							*/

/* TOUCHCOMMAND is the system call to touch to support altering the date on
 * the /usr/local/etc/jugtail.pid file such that the possibility of running
 * a make script via cron will allow a target depencency on the database
 * to allow SIGHUP'ing jugtail.  This usage may be redundant, but the
 * more ways to do a task the better.  The "%s" is required and is the
 * holder for the /usr/local/etc/jugtail.pid filename.	*/

/* CONFIGURE - stop,  don't (re)move this line, configure needs it. */
#define CATCOMMAND	"/usr/bin/cat %s >> %s"
#define SORTCOMMAND	"/usr/bin/sort -d -f -u -o %s -t'	' -T /tmp +1.0 %s"
#define TOUCHCOMMAND	"/usr/bin/touch -c %s"

#endif /* JUGTAIL_CONF_H */
