/*****************************************************************************
 * File:	jughead.h
 *
 * Author:	Rhett "Jonzy" Jones
 *		jonzy@cc.utah.edu
 *
 * Date:	May 20, 1993
 *
 * Modifed:	May 22, 1993, by Rhett "Jonzy" Jones.
 *		Removed the external definitions for exceptionHost',
 *		'exceptionPort', and 'exceptionSelStr', and added the
 *		variable 'nogos' to support a list of exceptions.
 *
 *		July 24, 1994, by Rhett "Jonzy" Jones.
 *		Changed 'searchPort' to 'port2use' and moved the
 *		declaration to search.c.  The following variables
 *		are now used in search.c to support the use of
 *		overriding and variables defined in jughead.conf.h
 *		with the use of the jughead.conf file:
 *		jughead.conf can be overrided via jughead.conf:
 *		delimiters, defaultboolop, jugheadhelptitl, usagerror,
 *		wildcarderr, tomnyprcserr, noforkerr, gtstrerr, readerr,
 *		tmpfilename, catcommand, rmcommand, sortcommand, touchcommand,
 *		port2use, maxprocs, maxitems2return.
 *
 *		September 20, 1994, by Rhett "Jonzy" Jones.
 *		Gave support for the -V flag which is used in conjunction
 *		with the -b flag to build a database file for veronica
 *		which does not contain any "Disallow" gopher paths.
 *
 *		September 27, 1994, by Rhett "Jonzy" Jones.
 *		Removed all use of rm.
 *
 * Description:	Header file for use with "jughead.c" and "getargs.c".
 *
 * Bugs:	No known bugs.
 *
 * Copyright:	Copyright 1993, 1994, University of Utah Computer Center.
 *		JUGHEAD (TM) is a trademark of Archie Comic Publications, Inc.
 *		and is used pursuant to license.  This source may be used and
 *		freely distributed as long as this copyright notice remains
 *		intact, and is in no way used for any monetary gain, by any
 *		institution, business, person, or persons.
 *
 ****************************************************************************/

#include "utils.h"

/* These defines were taken from "GSgopherobj.h". */
#define A_FILE      '0'      /* Types of objects */
#define A_DIRECTORY '1'
#define A_CSO       '2'
#define A_ERROR     '3'
#define A_MACHEX    '4'
#define A_PCBIN     '5'
#define A_INDEX     '7'
#define A_TELNET    '8'
#define A_UNIXBIN   '9'
#define A_SOUND     's'
#define A_EVENT     'e'
#define A_CALENDAR  'c'
#define A_GIF       'g'
#define A_HTML      'h'
#define A_TN3270    'T'
#define A_MIME      'M'
#define A_IMAGE     'I'
#define A_EOI	    '.'

#define BUFFERSIZE	2048			/* The size of our buffer. */
#define DEFAULTPORT	"70"			/* The default port to use. */
#define EMPTYSTRING	""			/* The empty C string. */
#define FIRSTMENU	0			/* The level of indention. */
#define INDENTSTR	"    "			/* What we indent with. */
#define MAXHOSTS	50			/* The maximum number of hosts2search. */
#define NIL		(void *)0L		/* Same as NULL, but ... Oh well. */

#define YEP		'1'			/* The pathway as been printed. */
#define NOPE		'\0'			/* The pathway has not been printed. */

typedef struct { char	*sStr,			/* The selector string. */
			*hStr,			/* The host string. */
			*pStr;			/* The port string. */
	       } ListInfo;			/* List info about the host or message. */

typedef struct node { ListInfo	  info;		/* The info contained at this node. */
		      struct node *next,	/* Pointer to the next node. */
				  *last;	/* The last node before this one. */
		    } List;

/* The following are declared in "jughead.c". */
extern char	buffer[BUFFERSIZE],
		path[BUFFERSIZE],
		pathPrinted[50],
		*searchHosts[MAXHOSTS],
		*initialHost,
		*selStr,
		*hostStr,
		*portStr,
		*fileName,
		*userName,
		*veronica;
extern int	numSearchHosts,
		debug,
		info4dirsOnly,
		info4allItems,
		listHosts,
		listHostsNPorts,
		onlyDoHosts,
		onlyDoHostsT,
		buildDataFile,
		menuFlag,
		printLineNumbers,
		printDTree,
		printDTreeDirs,
		time2process;
extern short	buildIndex,
		doSearch;
extern List	*nogos;

/* The following are declared in "search.c". */
extern char	*logFile,
		*hostname,
		*jugheadhelp,
		*errorhost,
		*delimiters,
		*defaultboolop,
		*jugheadhelptitl,
		*usagerror,
		*wildcarderr,
		*tomnyprcserr,
		*noforkerr,
		*gtstrerr,
		*readerr,
		*tmpfilename,
		*catcommand,
		*sortcommand,
		*touchcommand;
int		port2use,
		maxprocs,
		maxitems2return;

#ifdef USEPROTOTYPES
	extern int	GetArguments(int argc,char *argv[],char **fileName,char **logFile);
	extern void	InitPath(void);
#else
	extern int	GetArguments();
	extern void	InitPath();
#endif
