/*****************************************************************************
 * File:	path.c
 *
 * Author:	Rhett "Jonzy" Jones
 *		jonzy@cc.utah.edu
 *
 * Date:	May 23, 1994.
 *
 * Modified:	May 23, 1994, by Rhett "Jonzy" Jones.
 *		Modified PushPath() to also process the selector string,
 *		host string, and port string.
 *
 *		June 11, 1994, by Rhett "Jonzy" Jones.
 *		Added #ifdef NEED_MALLOC_H to give support for BSD.
 *
 * Description:	Routines used to print the current path to a given
 *		gopher menu item.  These routines use a stack
 *		implemented with a doubly linked list
 *
 * Routines:	int PopPath(void);
 *		int PrintPath(void);
 *		int PushPath(char *dStr,char *sStr,char *hStr,char *pStr);
 *
 * Bugs:	No known bugs.
 *
 * Copyright:	Copyright 1993, 1994, University of Utah Computer Center.
 *		JUGHEAD (TM) is a trademark of Archie Comic Publications, Inc.
 *		and is used pursuant to license.  This source may be used and
 *		freely distributed as long as this copyright notice remains
 *		intact, and is in no way used for any monetary gain, by any
 *		institution, business, person, or persons.
 *
 ****************************************************************************/

#ifdef NEED_MALLOC_H
#	include <malloc.h>
#endif
#ifdef NEXT
#	include <libc.h>
#else
#	include <stdlib.h>
#endif
#include <stdio.h>
#include <string.h>

#define NIL	(PType *)0

typedef struct PN { char	*str;	/* The string of concern. */
		    struct PN	*next,	/* Pointer to the next item. */
				*last;	/* Pointer to the previous item. */
		  } PType;

static PType	*head = NIL,		/* Bottom of the stack. */
		*tail = NIL;		/* Top of the stack. */

extern FILE	*rptPtr;	/* Defined in "jughead.c". */

/*****************************************************************************
 * PopPath returns true is the top of stack could be popped and
 * false otherwise.
 ****************************************************************************/
int PopPath()
{	PType	*tmp;	/* Temporary node. */

	if (tail)
		{
		tmp = tail->last;
		tmp->next = NIL;
		(void)free(tail->str);
		(void)free((char *)tail);
		tail = tmp;
		return(1);
		}
	return(0);

}	/* PopPath */

/*****************************************************************************
 * PrintPath returns the number of items in the stack and prints the
 * stack contents indented such that the top of stack gets indented
 * the most.  If there is not stack this routine return 0.
 ****************************************************************************/
int PrintPath()
{	PType	*tmp;	/* Temporary node. */
	int	i,j;	/* Loop counters. */

	if (head)
		{
		for (i = 0, tmp = head; tmp; i++, tmp = tmp->next)
			{
			for (j = 0; j < i; j++)
				(void)fprintf(rptPtr,"    ");
			(void)fprintf(rptPtr,"%s\n",tmp->str);
			}
		return(i);
		}
	return(0);

}	/* PrintPath */

/*****************************************************************************
 * PushPath returns true if we were able to push the strings on the stack
 * and false otherwise.  When pushing the stack we create a string which
 * has the following format:
 *
 *        "dStr | {[sStr] hStr pStr}"
 *
 * Where " | " represents the tab character.
 ****************************************************************************/
int PushPath(dStr,sStr,hStr,pStr)
	char		*dStr,		/* The display string. */
			*sStr,		/* The selector string. */
			*hStr,		/* The host string. */
			*pStr;		/* The port string. */
{	PType		*tmp;		/* Temporary node. */
	unsigned	numChars;	/* Size of the string to create. */

	if (tmp = (PType *)malloc(sizeof(PType)))
		{
		numChars = strlen(dStr) + strlen(sStr) +
			   strlen(hStr) + strlen(pStr) + 8;
		if (tmp->str = (char *)malloc(numChars * sizeof(char)))
			{

			/* Create the string for the stack.*/
			(void)strcpy(tmp->str,dStr);
			(void)strcat(tmp->str,"\t{[");
			(void)strcat(tmp->str,sStr);
			(void)strcat(tmp->str,"] ");
			(void)strcat(tmp->str,hStr);
			(void)strcat(tmp->str," ");
			(void)strcat(tmp->str,pStr);
			(void)strcat(tmp->str,"}");

			/* Set the stack pointers somewhere meaningful. */
			tmp->next = tmp->last = NIL;

			if (!head)
				head = tail = tmp;
			else
				{
				tail->next = tmp;
				tmp->last = tail;
				tail = tmp;
				}
			return(1);
			}
		}
	return(0);

}	/* PushPath */
