/*****************************************************************************
 * File:	dirTree.h
 *
 * Author:	Rhett "Jonzy" Jones
 *		jonzy@cc.utah.edu
 *
 * Date:	March 27, 1993
 *
 * Modifed:	March 30, 1993, by Rhett "Jonzy" Jones.
 *		Added PrintDirTree().
 *
 * Description:	Header file for use with "dirTree.c".
 *
 * Bugs:	No known bugs.
 *
 * Copyright:	Copyright 1993, 1994, University of Utah Computer Center.
 *		JUGHEAD (TM) is a trademark of Archie Comic Publications, Inc.
 *		and is used pursuant to license.  This source may be used and
 *		freely distributed as long as this copyright notice remains
 *		intact, and is in no way used for any monetary gain, by any
 *		institution, business, person, or persons.
 *
 ****************************************************************************/

#define DSTR	0
#define PSTR	1
#define HSTR	2
#define SSTR	3
#define STRS	4

typedef struct dirNode { long		lineNum;
			 char		*str;
			 struct dirNode	*left,
					*right,
					*tree;
		       } DirTreeType;
extern 	DirTreeType	*dirRoot;

#ifdef USEPROTOTYPES
  extern void	     PrintDirTree(DirTreeType *dTree,short whichStr);
  extern long	     InDirTree(DirTreeType *dTree,short whichStr);
  extern DirTreeType *WhatDirBranch(DirTreeType *dTree,short whichStr);
  extern DirTreeType *BuildDirTree(DirTreeType *dTree);
  extern void	     WaterTree(char *sStr,char *hStr,char *pStr);
#else
  extern void	     PrintDirTree();
  extern long	     InDirTree();
  extern DirTreeType *WhatDirBranch();
  extern DirTreeType *BuildDirTree();
  extern void	     WaterTree();
#endif
