/*	$Id: conf.c,v 1.5 2005/08/13 12:03:12 aon Exp $	*/

/*
 * Copyright (c) 2005 Antti Nyknen <aon@iki.fi>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "conf.h"

struct config	config;

static const char rcsid[] = "$Id: conf.c,v 1.5 2005/08/13 12:03:12 aon Exp $";

static int	parse_line(char *);
static int	add_value(char *, char *);

void
parse_config(char *conf_file)
{
	char buf[BUFSIZ], *p;
	FILE *confh;

	confh = fopen(conf_file, "r");
	if (confh == NULL) {
		perror(conf_file);
		exit(EXIT_FAILURE);
	}

	memset(&config, '\0', sizeof(struct config));

	while (fgets(buf, sizeof(buf), confh) != NULL) {
		if ((p = strchr(buf, '\n')) == NULL) /* too long line */
			continue;
		*p = '\0';
		if (parse_line(buf) < 0) {
			fprintf(stderr, "%s: erroneous configuration file.\n",
			    conf_file);
			exit(EXIT_FAILURE);
		}
	}
	
	if (ferror(confh) != 0) {
		perror(conf_file);
		exit(EXIT_FAILURE);
	}

	if (config.document_root[0] == '\0') {
		fprintf(stderr, "document_root needs to be specified.\n");
		exit(EXIT_FAILURE);
	}

	fclose(confh);
}

static int
add_value(char *opt, char *val)
{
	if (val == NULL) {
		fprintf(stderr, "%s needs a value.\n", opt);
		return(-1);
	}

	if (strcmp(opt, "document_root") == 0) {
		strncpy(config.document_root, val, MAXPATHLEN - 1);
		config.document_root[MAXPATHLEN-1] = '\0';
		return(0);
	} else if (strcmp(opt, "accesslog_file") == 0) {
		strncpy(config.accesslog_file, val, MAXPATHLEN - 1);
		config.accesslog_file[MAXPATHLEN-1] = '\0';
		return(0);
	} else if (strcmp(opt, "user") == 0) {
		strncpy(config.user, val, MAXLOGNAME - 1);
		config.user[MAXLOGNAME-1] = '\0';
		return(0);
	} else if (strcmp(opt, "chroot") == 0) {
		strncpy(config.chroot_dir, val, MAXPATHLEN - 1);
		config.chroot_dir[MAXPATHLEN-1] = '\0';
		return(0);
	} else if (strcmp(opt, "port") == 0) {
		strncpy(config.port, val, NI_MAXSERV - 1);
		config.port[NI_MAXSERV-1] = '\0';
		return(0);
	} else {
		fprintf(stderr, "%s: unrecognized option.\n", opt);
		return(-1);
	}
}

static int
parse_line(char *line)
{
	char *p, *opt, *val;

	p = strchr(line, '#');
	if (p != NULL)
		*p = '\0';
	opt = line + strspn(line, " \t\r\n");
	if (strlen(opt) == 0)
		return(0);
	val = strchr(opt, ' ');
	if (val != NULL)
		*val++ = '\0';
	if (add_value(opt, val) < 0)
		return(-1);
	return(0);
}
