#!/usr/local/bin/python
"""
    PyGS.py - A server for the gopher protocol.
    Copyright (C) 2001  Adam Gurno [adam@gurno.com] [GPG key in AUTHORS]

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""

# pygs - a gopher server written entirely in python.

import string, os, socket, asyncore, asynchat

#custom gopher imports
import gopher_parse
import gopher_format
import gopher_handle

__version__ = "0.3"

# Gopher connection states ###########################
# yeah, this looks like C, sue me...

GC_Ack = 1
GC_Send = 2
GC_Other = -1

# ERROR classes ######################################################
# FWIW, these are the gopher error classes...
class GopherRequestError(Exception):
	pass

# Settings class ##########################################################
class Settings:
	pass

# Version printout #############################################################
def version_and_quit(name_of_program):
	print name_of_program, __version__
	print
	sys.exit(0)

# Help printout ##############################################################
def help_and_quit(name_of_program):
	print "%s command line options:" % name_of_program
	print "-? -- Print this help and quit"
	print "-l -- Print GPL license information and quit."
	print "-v -- Print version information and quit"
	print "-c location -- Alternate configuration file location" 
	print "-s -- Server name or IP"
	print "-p -- Port number to use."
	print
	print "%s is licensed under the GNU GPL.  '%s -l' for more information." % (name_of_program, name_of_program)
	
	sys.exit(0)

# configure_program ##########################################################
def configure_program(arg_list):
	import getopt
	__doc__ = "This adds settings from configuration files and the command line to run the program with"
	sets_obj = {} #this is what we're going to return

	conf = ConfigParser.ConfigParser()
	conf.read(sets_obj.setdefault("conf_file", "pygs.conf"))

	if conf.has_option ("general", "server_name"):
		sets_obj["server_name"] = conf.get ("general", "server_name")
	else: sets_obj["server_name"] = "localhost"
	if conf.has_option ("general", "port"):
		sets_obj["port"] = conf.get ("general", "port")
	else: sets_obj["port"] = "5353"
	if conf.has_option ("file", "ignored_files"):
		sets_obj["ignored"] = string.split(conf.get ("file", "ignored_files"))
	else: sets_obj["ignored"] = []
	if conf.has_option ("file", "text_extensions"):
		sets_obj["text_extensions"] = string.split(conf.get ("file", "text_extensions"))
	else: sets_obj["text_extensions"] = []

	return sets_obj

# gopher_connection ############################################################
class gopher_connection (asynchat.async_chat):

        def __init__ (self, server, sock, addr):
                asynchat.async_chat.__init__ (self, sock)
                self.server = server
                self.addr = addr
		self.cwd = os.getcwd()
                self.set_terminator ('\r\n')
                self.data = ''
                self.push ('\r\n') #ack the connection
		self.state = GC_Send

        def collect_incoming_data (self, data):
                self.data = self.data + data

        def found_terminator (self):
                line = string.split(self.data, '\t', 1)[0] # for now, no '+'s
                self.data = ''
		
		# request line manglings
		line = os.getcwd() + "/" + line
		line = os.path.normpath(os.path.normcase(line))
		if (line[:(len(os.getcwd()))] != os.getcwd()):
			self.server.push_line (self, "Request for %s bad" % line)
		self.server.push_line (self,line) #DEBUG 
		
		try :
			self.handle_request (line)
		except GopherRequestError, reason:
			self.server.push_line (self, reason)
			self.push (str(reason))

		self.state = GC_Other
		self.close_when_done()

        def handle_request (self, request_str):
		if not os.path.exists(request_str):
			raise GopherRequestError, "Does not exist"
		elif os.path.islink(request_str):
			raise GopherRequestError, "Symbolic Link"
		elif os.path.isdir(request_str):
			gopher_handle.handle_dir(request_str, self)
		elif os.path.isfile(request_str):
			gopher_handle.handle_file(request_str, self)
		else:
			raise GopherRequestError, "WTF?"
		
        def push_line (self, line):
                self.push ('%s\r\n' % (line))

        def handle_close (self):
                self.close()

        def close (self):
                del self.server.channels[self]
                asynchat.async_chat.close (self)

# gopher_server ################################################################
class gopher_server (asyncore.dispatcher):

        SERVER_IDENT = 'Pygs Gopher Server (V%s)' % __version__

        channel_class = gopher_connection

        spy = 1

        def __init__ (self, ip='', port=70, options={}):
                self.port = port
                self.create_socket (socket.AF_INET, socket.SOCK_STREAM)
                self.bind ((ip, port))
                print '%s started on port %d' % (self.SERVER_IDENT, port)
                self.listen (5)
                self.channels = {}
                self.count = 0
		self.ip = ip
		self.options = options

        def handle_accept (self):
                conn, addr = self.accept()
                self.count = self.count + 1
                print 'client #%d - %s:%d' % (self.count, addr[0], addr[1])
                self.channels[self.channel_class (self, conn, addr)] = 1

        def push_line (self, from_channel, line):
                if self.spy:
                        print '%s' % (line)
                for c in self.channels.keys():
                        if c is not from_channel:
                                c.push ('%s\r\n' % (line))

        def status (self):
                lines = [
                        '<h2>%s</h2>' % self.SERVER_IDENT,
                        '<br>Listening on Port: %d'     % self.port,
                        '<br><b>Total Sessions:</b> %d'     % self.count,
                        '<br><b>Current Sessions:</b> %d' % (len(self.channels))
                        ]
                #return status_handler.lines_producer (lines)

        def writable (self):
                return 0


# main ########################################################################
if __name__ == '__main__':
	import sys, ConfigParser

	settings_dict = configure_program (sys.argv)
	print settings_dict

        s = gopher_server ('', int(settings_dict["port"]), settings_dict)
        asyncore.loop()
